﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut.h>

namespace nw {
namespace internal {
namespace dw {

class UIElement;

//---------------------------------------------------------------------------
//! @brief UI要素のスタイルを示します。
//---------------------------------------------------------------------------
class Style
{
public:
    struct Reference
    {
        /* implicit */ Reference(Style& owner);

        Style& owner;
        nw::ut::LinkListNode node;
    };

public:
    Style();
    virtual ~Style(){}

public:
    virtual bool CanApply(UIElement& element) = 0;
    virtual void Apply(UIElement& element) = 0;

private:
    Reference m_Link;
};

} // dw
} // internal
} // nw
