﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

class Label : public UIElement
{
private:
    static const u32 MAX_TEXT_LENGTH = 128;

public:
    /* ctor */ Label();

public:
    virtual const char* GetText() const = 0;
    virtual void SetText(const char* value);
    virtual void SetText(const char* value, int length) = 0;

    TextAlignment GetTextAlignment() const;
    void SetTextAlignment(TextAlignment value);

    f32 GetTextScale() const;
    void SetTextScale(float value);

    const nw::ut::Color4f& GetTextColor() const;
    void SetTextColor(const nw::ut::Color4f& value);

    virtual u32 GetMaxTextLength()
    {
        return MAX_TEXT_LENGTH;
    }

protected:
    /*override*/ const nw::math::Vector2 OnMeasure(UIRenderer& renderer) const;
    /*override*/ void OnRender(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;

private:
    inline const nw::math::Vector2 MeasureText(UIRenderer& renderer) const;

private:
    TextAlignment m_TextAlignment;
    f32 m_TextScale;
    nw::ut::Color4f m_TextColor;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "Label";
    }
#endif
};

} // dw
} // internal
} // nw
