﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_UIElementUtility.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief 最も深い階層にあるフォーカス可能UI要素を検索する関数オブジェクトです。
//---------------------------------------------------------------------------
class HighestLevelFocusableElementFinder : public nw::internal::dw::UIElementUtility::UnaryFunction
{
public:
    HighestLevelFocusableElementFinder();

public:
    void Reset();
    UIElement* GetResult() const;

    /*override*/ bool OnCurrentLevelChanged();

    /*override*/ bool operator ()(UIElement& element);

private:
    UIElement* m_pResult;
    u32 m_ResultLevel;
    u32 m_VisibleLevel;
};

} // dw
} // internal
} // nw
