﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_FileBrowserEntry.h>

namespace nw {
namespace internal {
namespace dw {

class FileBrowserExecuteEventArgs
{
    NW_DISALLOW_COPY_AND_ASSIGN(FileBrowserExecuteEventArgs);

public:
    explicit FileBrowserExecuteEventArgs(FileBrowserEntry& fileEntry, const char* pFilePath) :
        m_FileEntry(fileEntry),
        m_pFilePath(pFilePath)
    {
        NW_NULL_ASSERT(pFilePath);
    }

public:
    FileBrowserEntry& GetFileEntry() const
    {
        return m_FileEntry;
    }

    const char* GetFilePath() const
    {
        return m_pFilePath;
    }

private:
    FileBrowserEntry& m_FileEntry;
    const char* m_pFilePath;
};

} // dw
} // internal
} // nw
