﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dev/dev_Fs.h>
#include <nw/dev/dev_FileLogger.h>
#include <nw/ut/ut_FsFileStream.h>

namespace nw {
namespace dev {

//---------------------------------------------------------------------------
//! @brief        指定ファイルにデバッグ出力を行うクラスです。
//!
//! @details :category     デバッグ
//---------------------------------------------------------------------------
class FsFileLogger : public FileLogger
{
private:
#if defined( NW_USE_NINTENDO_SDK )
    static const u32 BUFFER_ALIGNMENT = 32;
#else
    static const u32 BUFFER_ALIGNMENT = PPC_IO_BUFFER_ALIGN;
#endif
    static const u32 DEFAULT_BUFFER_SIZE = 256;

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。
    typedef ::nw::internal::winext::FSClient FSClient;
    typedef ::nw::internal::winext::FSCmdBlock FSCmdBlock;
#endif // defined( NW_PLATFORM_WIN32 )

public:
    //! @brief コンストラクタです。
    FsFileLogger() {}

    //! @brief デストラクタです。
    ~FsFileLogger() {}

public:
    //---------------------------------------------------------------------------
    //! @brief        出力先ファイルを開きます。
    //!
    //! @param[in]    fsClient    FS のクライアントです。
    //! @param[in]    fsCmdBlock  FS のコマンドブロックです。
    //! @param[in]    filePath    ロガーで使用するバッファへのポインタです。
    //!
    //! @return       成功した場合は true、失敗した場合は false を返します。
    //---------------------------------------------------------------------------
    bool Open(FSClient* fsClient, FSCmdBlock* fsCmdBlock, const char* filePath);

protected:
    /* override */ u32 GetBufferAlignment() const
    {
        return BUFFER_ALIGNMENT;
    }

private:
    ut::FsFileStream m_FileStream;

    char m_DefaultBuffer0[DEFAULT_BUFFER_SIZE];
    char m_DefaultBuffer1[DEFAULT_BUFFER_SIZE];
};

} // namespace dev
} // namespace nw
