﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEV_MOUSE_CAFE_H_
#define NW_DEV_MOUSE_CAFE_H_

#include <nw/dev/dev_Mouse.h>
#include <nw/dev/cafe/dev_KeyboardMouseDeviceCafe.h>

namespace nw
{
namespace dev
{

//---------------------------------------------------------------------------
//! @brief        PC マウス入力を扱うクラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class MouseCafe : public Mouse
{
public:
    NW_UT_RUNTIME_TYPEINFO(Mouse)

#if defined(NW_DEV_PAD_ENABLE)
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    MouseCafe();

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~MouseCafe() {}


    //---------------------------------------------------------------------------
    //! @brief        SetPointerBound で設定した範囲でポインタ位置をクランプするか
    //!               どうかを取得します。
    //!
    //! @return       ポインタ位置をクランプする場合、 true を返します。
    //---------------------------------------------------------------------------
    bool IsEnableClampPointer() const { return m_Flag.IsMaskOn( MASK_ENABLE_CLAMP_POINTER ); }

    //---------------------------------------------------------------------------
    //! @brief        SetPointerBound で設定した範囲でポインタ位置をクランプするか
    //!               どうかを設定します。
    //!
    //! @param[in]    enable    有効にする場合、 true を指定します。
    //---------------------------------------------------------------------------
    void SetEnableClampPointer(bool enable) { m_Flag.ChangeMask( MASK_ENABLE_CLAMP_POINTER, enable ); }

    //---------------------------------------------------------------------------
    //! @brief        接続可能かどうかを取得します。
    //!
    //! @return       接続されている場合、 true を返します。
    //---------------------------------------------------------------------------
    virtual bool IsConnected() const { return m_IsConnected; }


    //---------------------------------------------------------------------------
    //! @brief        キーボード・マウスデバイスを設定します。
    //!
    //! @param[in]    device    設定するデバイスへのポインタです。
    //---------------------------------------------------------------------------
    void SetKeyboardMouseDevice( KeyboardMouseDeviceCafe* device ){ m_KeyboardMouseDevice = device; }

    //---------------------------------------------------------------------------
    //! @brief        キーボード・マウスデバイスを取得します。
    //!
    //! @return       キーボード・マウスデバイスを返します。
    //---------------------------------------------------------------------------
    KeyboardMouseDeviceCafe* GetKeyboardMouseDevice() const { return m_KeyboardMouseDevice; }

protected:
    //! @brief マウス入力更新の実装です。
    void UpdateImpl();
#else

    MouseCafe() {}

    virtual ~MouseCafe() {}

    bool IsEnableClampPointer() const { return false; }

    void SetEnableClampPointer(bool enable) {}

    virtual bool IsConnected() const { return false; }

    void SetKeyboardMouseDevice( KeyboardMouseDeviceCafe* ){}

    KeyboardMouseDeviceCafe* GetKeyboardMouseDevice() const { return NULL; }

protected:
    void UpdateImpl() {}
#endif // NW_DEV_PAD_ENABLE

    enum FlagMask
    {
        MASK_ENABLE_CLAMP_POINTER = 1,      //!< m_PointerBoundMin、 m_PointerBoundMax の範囲でポインタ位置をクランプするかどうかのフラグ値です。
    };

    bool                     m_IsConnected;         //!< 接続されているかを表します。
    nw::ut::BitFlag32        m_Flag;                //!< 設定フラグです。

    KeyboardMouseDeviceCafe* m_KeyboardMouseDevice; //!< 使用するキーボード・マウスデバイスです。
};

} // namespace dev
} // namespace nw

#endif // NW_DEV_MOUSE_CAFE_H_
