﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DBG_H_
#define NW_DBG_H_

//---------------------------------------------------------------------------
//!  @namespace  nw::dbg
//!  @brief      デバッグライブラリの名前空間です。
//!
//!  @details    nw::dev 名前空間に統合いたしました。nw::dbg は単なる nw::dev の using となっています。
//---------------------------------------------------------------------------

#include <nw/dev/dev_Logger.h>
#include <nw/dev/dev_FileLogger.h>

#if defined(NW_PLATFORM_CAFE)
#include <nw/dev/dev_MapFile.h>
#endif

namespace nw {
namespace dbg {
#if defined(NW_PLATFORM_CAFE)
    using ::nw::dev::MapFile;
#endif
    using ::nw::dev::LoggerBase;
    using ::nw::dev::Logger;
    using ::nw::dev::FileLogger;
}
}


#endif // NW_DBG_H_
