﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_TOUCH_OFF_CHECK_BUTTON_H_
#define NW_CTRL_TOUCH_OFF_CHECK_BUTTON_H_

#include <nw/ctrl/ctrl_CheckButton.h>

namespace nw
{

namespace ctrl
{

//---------------------------------------------------------------------------
//! @brief ボタンが押されるたびにトグルで特定のアニメの状態が切り替わるボタンのTouchOff版です。
//!
//! @details
//! このボタンは、CheckButtonの押されたときの挙動を、NormalButtonではなくTouchOffButtonの
//! 挙動にしたものです。OnOffアニメ及びDownアニメの作り方はTouchOffButtonと同じです。
//!
//! Checkアニメについては、CheckButtonと変わりありません。
//!
//---------------------------------------------------------------------------
class TouchOffCheckButton : public CheckButton
{
public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(CheckButton);

    //! @brief コンストラクタです。
    //!
    TouchOffCheckButton() : CheckButton() {}

protected:
    //! @brief ボタンの挙動をカスタマイズするためにオーバーライドします。
    //!
    virtual bool ProcessOff();
    virtual bool ProcessOn();
    virtual void FinishDown();

};

} // namespace nw::ctrl
} // namespace nw

#endif // NW_CTRL_TOUCH_OFF_CHECK_BUTTON_H_
