﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_TOUCH_OFF_BUTTON_H_
#define NW_CTRL_TOUCH_OFF_BUTTON_H_

#include <nw/ctrl/ctrl_AnimButton.h>

namespace nw
{

namespace ctrl
{

//---------------------------------------------------------------------------
//! @brief DOWNアニメを再生した後にOFF状態に戻るボタンです。
//!
//! @details
//! TouchOffButtonは、NormalButtonと似た挙動のボタンですが、押したあとON状態
//! ではなく、OFF状態に戻ります。
//!
//! このため、デザイナには、DOWNアニメの始まりとONアニメの始まりの状態が同じになる
//! ようにアニメを作成していただく必要があります。
//!
//! 状態の変化の仕方としては、DOWNアニメが終了してSTATE_DOWN_IDLEとなった
//! 直後にSTATE_OFF_IDLEとなります。
//!
//! 同じフレームに、STATE_DOWNからSTATE_DOWN_IDLE、STATE_DOWN_IDLEから
//! STATE_OFF_IDLEという二回のコールバックが来ることになりますのでご注意
//! ください。
//!
//! また、DecisionButtonと異なり、TouchOffButtonはデフォルトではIsExcludeDown
//! がfalseになっていますので、押されたときに他のボタンが押されることを
//! 妨げません。
//!
//! DRC等のタッチスクリーンのデバイスで、タッチしたときにボタンが凹み、その上で離すと
//! ボタンが押されるようにするには、押された後にOFF状態になった方が自然な挙動に
//! なるため、タッチスクリーンのデバイスにはこのボタンが向いています。
//!
//---------------------------------------------------------------------------
class TouchOffButton : public AnimButton
{
public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(AnimButton);

    //! @brief コンストラクタです。
    //!
    TouchOffButton() : AnimButton() {}

protected:
    //! @brief ボタンの挙動をカスタマイズするためにオーバーライドします。
    //!
    virtual bool ProcessOff();
    virtual bool ProcessOn();
    virtual void FinishDown();

};

} // namespace nw::ctrl
} // namespace nw

#endif // NW_CTRL_TOUCH_OFF_BUTTON_H_
