﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_H_
#define NW_CTRL_H_

//! @namespace nw::ctrl
//!
//! @brief レイアウトのデフォルトコントロールの名前空間です。
//!
//! @details
//! コントロールは、レイアウトにユーザーインターフェース等の機能を持たせ
//! るための機能で、デフォルトコントロールは、そのレイアウトライブラリに
//! よる実装です。ライブラリユーザは、デフォルトコントロールを拡張したり、
//! あるいはまったく使用せずに独自のコントロールを実装したりすることが
//! できます。
//!
//! デフォルトコントロールのボタンは AnimButton クラスの派生クラス
//! として実装されています。
//!
//! レイアウトでデフォルトコントロールを使用するには、
//! lyt::Layout::Build() の引数で DefaultControlCreator を指定します。

#include <nw/ctrl/ctrl_ButtonBase.h>
#include <nw/ctrl/ctrl_ButtonGroup.h>
#include <nw/ctrl/ctrl_AnimButton.h>
#include <nw/ctrl/ctrl_DefaultControlCreator.h>
#include <nw/ctrl/ctrl_NormalButton.h>
#include <nw/ctrl/ctrl_DecisionButton.h>
#include <nw/ctrl/ctrl_CheckButton.h>
#include <nw/ctrl/ctrl_SelectButton.h>
#include <nw/ctrl/ctrl_TouchOffButton.h>
#include <nw/ctrl/ctrl_TouchOffCheckButton.h>
#include <nw/ctrl/ctrl_DragButton.h>

#endif // NW_LYT_H_
