﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_PLATFORM_CAFE_H_
#define NW_CONFIG_PLATFORM_CAFE_H_

#include <stdio.h>
#include <cafe/os.h>

#if !defined(NW_RELEASE)
  #define NW_CONSOLE_ENABLE
#endif

namespace nw {
namespace ut {

void Printf(const char *fmt, ...);
void TPrintf(const char *fmt, ...);
void Panic( const char* fileName, int line, const char* fmt, ...);
void TPanic( const char* fileName, int line, const char* fmt, ...);

} // namespace ut
} // namespace nw




#define NW_BIG_ENDIAN

#define NW_ENABLE_FLOAT64

// NOTE: CAFE というマクロと cafe というマクロが CAFE_SDK で定義されているので、Cafe にしておく
#define NW_PLATFORM_NAME   Cafe
#define NW_PLATFORM_CAFE

#define NW_TARGET_CAFE

#define NW_HALT     do { int* a = NULL; *a = 1; } while (0);

#if defined(NW_CONSOLE_ENABLE)
  #define NW_TLOG     ::nw::ut::TPrintf
  #define NW_LOG      ::nw::ut::Printf
#else
  #define NW_TLOG(...) ((void)0)
  #define NW_LOG(...)  ((void)0)
#endif


/* NW_CONFIG_PLATFORM_CAFE_H_ */
#endif
