﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_COMPILER_GCC_H_
#define NW_CONFIG_COMPILER_GCC_H_

#define NW_NO_INLINE(function)    function __attribute__((noinline))

#define NW_FILE_NAME __FUNCTION__
#define NW_LINE_NUMBER __LINE__
#define NW_ALIGN(n)   __align(n)

#define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))
#define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
#define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)

#if ! defined(_CHAR8_DEFINED)
#define _CHAR8_DEFINED
typedef char                char8;
#endif

#if ! defined(_CHAR16_DEFINED)
#define _CHAR16_DEFINED
typedef wchar_t             char16;
#endif

#if ! defined(_CHAR32_DEFINED)
#define _CHAR32_DEFINED
typedef u32                 char32;
#endif

/* NW_CONFIG_COMPILER_GCC_H_ */
#endif
