﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_COMPILER_CWCC_H_
#define NW_CONFIG_COMPILER_CWCC_H_

#define NW_NO_THROW     _MSL_NO_THROW
#define NW_NO_INLINE(function)    function __attribute__((never_inline))
#define NW_FORCE_INLINE     inline // TODO: 調べてちゃんと定義する。

#define NW_FILE_NAME __FUNCTION__
#define NW_LINE_NUMBER __LINE__
#define NW_ALIGN(n) // __align(n)

#define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc
#define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
#define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)

#include <inttypes.h>
#include <stddef.h>
#include <stdarg.h>

#ifndef __cplusplus
    #include <stdbool.h>
#endif

typedef unsigned char           u8;
typedef unsigned short int      u16;
typedef unsigned int            u32;
typedef unsigned long long int  u64;

typedef signed char             s8;
typedef signed short int        s16;
typedef signed int              s32;
typedef signed long long int    s64;

typedef volatile u8             vu8;
typedef volatile u16            vu16;
typedef volatile u32            vu32;
typedef volatile u64            vu64;

typedef volatile s8             vs8;
typedef volatile s16            vs16;
typedef volatile s32            vs32;
typedef volatile s64            vs64;

typedef float                   f32;
typedef double                  f64;

typedef volatile f32            vf32;
typedef volatile f64            vf64;


#if ! defined(_SPTR_DEFINED)
#define _SPTR_DEFINED
typedef intptr_t                sptr;
#endif

#if ! defined(_UINT_DEFINED)
#define _UINT_DEFINED
typedef uintptr_t               uptr;
#endif

#if ! defined(_CHAR8_DEFINED)
#define _CHAR8_DEFINED
typedef char                    char8;
#endif

#if ! defined(_CHAR16_DEFINED)
#define _CHAR16_DEFINED
typedef wchar_t                 char16;
#endif

#if ! defined(_CHAR32_DEFINED)
#define _CHAR32_DEFINED
typedef u32                     char32;
#endif

#if ! defined(_BIT8_DEFINED)
#define _BIT8_DEFINED
typedef unsigned char           bit8;
#endif

#if ! defined(_BIT16_DEFINED)
#define _BIT16_DEFINED
typedef unsigned short          bit16;
#endif

#if ! defined(_BIT32_DEFINED)
#define _BIT32_DEFINED
typedef unsigned int            bit32;
#endif

#if ! defined(_BIT64_DEFINED)
#define _BIT64_DEFINED
typedef unsigned long long int  bit64;
#endif

#if ! defined(_UINT_DEFINED)
#define _UINT_DEFINED
typedef unsigned int uint;
#endif

#if ! defined(_U96_DEFINED)
#define _U96_DEFINED
typedef struct
{
    u32 w[3];
}
u96;
#endif

#if ! defined(_U128_DEFINED)
#define _U128_DEFINED
typedef struct
{
    u32 w[4];
}
u128;
#endif

#if ! defined(_VU96_DEFINED)
#define _VU96_DEFINED
typedef volatile u96    vu96;
#endif

#if ! defined(_VU128_DEFINED)
#define _VU128_DEFINED
typedef volatile u128   vu128;
#endif

/* NW_CONFIG_COMPILER_CWCC_H_ */
#endif
