﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_COMPILER_CLANG_H_
#define NW_CONFIG_COMPILER_CLANG_H_

//#define NW_NO_THROW     _MSL_NO_THROW

#if defined(NW_DISABLE_NO_INLINE)
  #define NW_NO_INLINE(function) function
#else
  #define NW_NO_INLINE(function)    function __attribute__((noinline))
#endif

#define NW_FORCE_INLINE     inline // TODO: Check and define properly.

#define NW_FILE_NAME __FUNCTION__
#define NW_LINE_NUMBER __LINE__
#define NW_ALIGN(n) // __align(n)

#include <inttypes.h>
#include <stddef.h>
#include <stdarg.h>

#ifndef __cplusplus
    #include <stdbool.h>
#endif

#include <types.h>

#if ! defined(_SPTR_DEFINED)
#define _SPTR_DEFINED
typedef intptr_t                sptr;
#endif

#if ! defined(_UPTR_DEFINED)
#define _UPTR_DEFINED
typedef uintptr_t               uptr;
#endif

#if ! defined(_CHAR8_DEFINED)
#define _CHAR8_DEFINED
typedef char                    char8;
#endif

#if ! defined(__CHAR16_DEFINED)
#define __CHAR16_DEFINED
typedef wchar_t                 char16;
#endif

#if ! defined(_CHAR32_DEFINED)
#define _CHAR32_DEFINED
typedef u32                     char32;
#endif

#if ! defined(_BIT8_DEFINED)
#define _BIT8_DEFINED
typedef unsigned char           bit8;
#endif

#if ! defined(_BIT16_DEFINED)
#define _BIT16_DEFINED
typedef unsigned short          bit16;
#endif

#if ! defined(_BIT32_DEFINED)
#define _BIT32_DEFINED
typedef u32                     bit32;
#endif

#if ! defined(_BIT64_DEFINED)
#define _BIT64_DEFINED
typedef unsigned long long int  bit64;
#endif

#if ! defined(_UINT_DEFINED)
#define _UINT_DEFINED
typedef unsigned int uint;
#endif

#if ! defined(_U96_DEFINED)
#define _U96_DEFINED
typedef struct
{
    u32 w[3];
}
u96;
#endif

#if ! defined(_U128_DEFINED)
#define _U128_DEFINED
typedef struct
{
    u32 w[4];
}
u128;
#endif

#if ! defined(_VU96_DEFINED)
#define _VU96_DEFINED
typedef volatile u96    vu96;
#endif

#if ! defined(_VU128_DEFINED)
#define _VU128_DEFINED
typedef volatile u128   vu128;
#endif

/* NW_CONFIG_COMPILER_CLANG_H_ */
#endif
