﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief アプリケーション HTML ドキュメントを、JavaScript からプレイレポートを利用できる状態で開くのに利用される引数の宣言
 */

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Result.h>
#include <nn/web/web_OfflineShowArg.h>

namespace nn { namespace web {

//--------------------------------------------------------------------------
/**
 * @brief アプリケーションに付加されたオフライン HTML を、
 *        JavaScript からプレイレポートを利用できる状態で開くための情報を構築するクラスです。
 *
 * @details
 * 本クラスはオフライン HTML 内でプレイレポートを利用できる状態にするために、
 * @ref ShowOfflineHtmlPageArg クラスの代わりに利用します。
 * 本クラスを利用してオフライン HTML を開く場合は、本クラスのインスタンスを
 * 直接 @ref ShowOfflineHtmlPage の引数に指定してください。
 */
class ShowOfflineHtmlPageArgWithPlayReport
    : public ShowOfflineHtmlPageArg
{
public:
    /**
     * @brief オフライン HTML を開く為の最低限の情報を持つクラスを作成します。
     *
     * @param[in] pDocumentPath 開きたいオフライン HTML へのパスを指定してください。
     *
     * @details pDocumentPath は NULL 終端されている必要があります。
     *          DocumentPathMaxLength -1 文字以下にする必要があります。
     */
    explicit ShowOfflineHtmlPageArgWithPlayReport(const char* pDocumentPath) NN_NOEXCEPT;

    /**
     * @brief (削除予定) オフライン HTML を開く為の最低限の情報を持つクラスを作成します。
     *
     * @deprecated 本 API は削除予定です。
     *             代わりに ShowOfflineHtmlPageArgWithPlayReport(const char* pDocumentPath)
     *             を使用してください。
     *
     * @param[in] id            ApplicationId を指定してください。
     * @param[in] pDocumentPath 開きたいオフラインHTMLへのパスを指定してください。
     *
     * @details 引数で指定した ApplicationId は使用されず、起動元の ApplicationId が使われます。
                pDocumentPathは NULL 終端されている必要があります。
     *          DocumentPathMaxLength -1 文字以下にする必要があります。
     */
    explicit ShowOfflineHtmlPageArgWithPlayReport(const nn::ApplicationId& id,
        const char* pDocumentPath) NN_NOEXCEPT;

    /**
     * @brief プレイレポートを利用するかどうかを設定します。
     *
     * @param[in] playReportEnabled プレイレポートを利用する場合は true を指定してください。
     *
     * @details false を指定した場合はプレイレポート利用のための JavaScript が提供されません。
     *          デフォルト値は true です。
     *          二度呼び出した場合、値は上書きされます。
     *          プレイレポートを利用する場合は Web Audio が強制的に有効になります。
     */
    void SetPlayReportEnabled(const bool playReportEnabled) NN_NOEXCEPT;
};

//--------------------------------------------------------------------------
/**
 * @brief (廃止予定) アプリケーションに付加されたオフライン HTML を、
 *        JavaScript からプレイレポートを利用できる状態で開くための情報を構築するクラスです。
 * @deprecated 型名「ShowApplicationHtmlDocumentPageArgWithPlayReport」は廃止予定です。ShowOfflineHtmlPageArgWithPlayReport を利用してください。
 */
NN_DEPRECATED typedef ShowOfflineHtmlPageArgWithPlayReport ShowApplicationHtmlDocumentPageArgWithPlayReport;

}} // namespace nn::web
