﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Cruiserが呼び出し元とのSessionを張るのに利用する共通 API (非公開)
 */

#pragma once

#include <queue>
#include <mutex>

#include <nn/applet/applet.h>
#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_LibraryApplet.h>
#include <nn/la/la_Api.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/web/web_SessionTypes.h>

namespace nn { namespace web { namespace detail {

//------------------------------------------------------------------------
/**
 * @brief セッションの実体クラスです。
 */
class SessionImpl
{
public:
    explicit SessionImpl() NN_NOEXCEPT;

    // 送信
    bool trySend(const SessionMessageHeader&, const void*) NN_NOEXCEPT;
    // 受信
    bool tryRecive(SessionMessage* pOutMessage) NN_NOEXCEPT;

    // LibraryAppletHandle をセット
    void setLibraryAppletHandle(const nn::applet::LibraryAppletHandle&) NN_NOEXCEPT;

private:
    bool canSend(size_t) const NN_NOEXCEPT;
    bool isSessionAvaliable() NN_NOEXCEPT;
    bool isLibraryAppletHandleAvaliable() NN_NOEXCEPT;
    void sendImpl(const SessionMessageHeader&, const void*) NN_NOEXCEPT;
    void sendAck(uint32_t) NN_NOEXCEPT;

    nn::os::Mutex mMutex;
    nn::applet::LibraryAppletHandle mLibraryAppletHandle;

    // 利用可能なStorage数,サイズの管理用
    const uint32_t PushCountMax = 10;
    const uint32_t PushStorageSizeMax = 1024 * 20;
    uint32_t mPushCount;
    uint32_t mPushStorageSize;
};

}}} // namespace nn::web::detail
