﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace rid {

    /**
     * @brief        起動可能なアプリケーションの一覧を取得します。
     *
     * @param[out]   outApplicationIdList   起動可能なアプリケーションの applicationId の一覧を格納する配列
     * @param[in]    count                  outApplicationIdList のサイズ
     * @param[in]    excludeNoRightsContent 権利の無いコンテンツを除外するか
     *
     * @return       起動可能なアプリケーションの数
     */
    int ListApplication(ncm::ApplicationId outApplicationIdList[], int count, bool excludeNoRightsContent = true) NN_NOEXCEPT;
}}
