﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/applet/applet_ApplicationControlForQuest.h>

namespace nn { namespace rid {

    /**
     * @brief        アプリケーションの起動要求を出します。
     *
     * @details      アプリケーションの起動前に行う必要がある処理を行った後に、アプリケーションを起動します。
     *
     * @param[in]    applicationId      起動要求を出すアプリケーションの applicationId を指定します。
     * @param[in]    restrictsNetwork    アプリケーションのネットワーク利用を制限するかを指定します。
     */
    void RequestToLaunchApplication(ncm::ApplicationId applicationId, bool restrictsNetwork = true) NN_NOEXCEPT;

    /**
     * @brief        アプリケーションの起動要求を出します。
     *
     * @details      アプリケーションの起動前に行う必要がある処理を行った後に、アプリケーションを起動します。
     *
     * @param[in]    applicationId      起動要求を出すアプリケーションの applicationId を指定します。
     * @param[in]    pAttribute         アプリケーション起動時に付加する拡張属性です。
     * @param[in]    restrictsNetwork    アプリケーションのネットワーク利用を制限するかを指定します。
     */
    void RequestToLaunchApplication(ncm::ApplicationId applicationId, const applet::ApplicationAttributeForQuest* pAttribute, bool restrictsNetwork = true) NN_NOEXCEPT;

    /**
     * @brief        ゲームカードのアプリケーションの起動要求を出します。
     *
     * @return       ゲームカードが挿入されていて起動できる場合は true, そうでない場合は false が返ります。
     */
    bool RequestToLaunchGameCardApplication() NN_NOEXCEPT;
}}
