﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>
#include <nv/nv_MemoryManagement.h>
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <vector>

namespace nn {
    namespace repair {
        //!< 文字列をストリーミングするクラスです。
        class StreamTextView : public glv::TextView
        {
        private:
            //!< 表示する最大行数
            int m_StringCountMax;

            //!< 表示開始要素位置
            int m_Index;

            //!< 表示文字列のベクトル
            std::vector<std::string> m_StringArray;

        public:
            StreamTextView(const glv::Rect& rect, float textSize) NN_NOEXCEPT
                : glv::TextView(rect, textSize)
                , m_Index(0)
            {
                m_StringCountMax = static_cast<int>(0.66 * rect.h / textSize);
            }

            //!< 現在の表示に一行追加します。
            void AppendValue(const std::string& text) NN_NOEXCEPT;

            //!< 現在の表示内容をクリアします。
            void Clear() NN_NOEXCEPT;

            //!< イベント発生時の挙動を提示します。
            virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT NN_OVERRIDE;

        private:
            // 表示を更新します。
            void Update() NN_NOEXCEPT;
        };
    }
}
