﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>
#include <nv/nv_MemoryManagement.h>
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <functional>

namespace nn {
    namespace repair {
        //!< ラベル付きボタン用クラスです。
        class LabelButton : public glv::Button
        {
        private:
            std::function<void()> m_MouseDownHandler;
            std::function<void()> m_WindowCreateHandler;
            std::function<void()> m_WindowDestroyHandler;

        protected:
            glv::Label* FitButton(glv::Label* pLabel, float fontSize, glv::space_t padding) NN_NOEXCEPT;

        public:
            LabelButton(std::function<void()> mouseDownFunction)  NN_NOEXCEPT
                : glv::Button(glv::Rect(20), true)
                , m_MouseDownHandler(mouseDownFunction)
                , m_WindowCreateHandler(nullptr)
                , m_WindowDestroyHandler(nullptr)
            {
            }

            LabelButton(const std::string& text, std::function<void()> mouseDownFunction) NN_NOEXCEPT
                : glv::Button(glv::Rect(20), true)
                , m_MouseDownHandler(mouseDownFunction)
                , m_WindowCreateHandler(nullptr)
                , m_WindowDestroyHandler(nullptr)
            {
                this->add(FitButton(new glv::Label(text, false), 50, 4));
            }

            LabelButton(const std::string& text, std::function<void()> mouseDownFunction,
                std::function<void()> windowCreateFunction, std::function<void()> windowDestroyFunction)
                : glv::Button(glv::Rect(20), true)
                , m_MouseDownHandler(mouseDownFunction)
                , m_WindowCreateHandler(windowCreateFunction)
                , m_WindowDestroyHandler(windowDestroyFunction)
            {
                this->add(FitButton(new glv::Label(text, false), 50, 4));
            }

            //!< イベント発生時の挙動を提示します。
            virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT NN_OVERRIDE;
        };
    }
}

