﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_SteadyClockTimePoint.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace ndd
{

const int SendDataCountMax      = 1;   //!< 送信データの最大数
const size_t SendDataSizeMax    = 1200;//!< 送信データの最大サイズ
const size_t ReceiveDataSizeMax = 1200;//!< 受信データの最大サイズ
const size_t DataIdSize         = 8;   //!< データIDのサイズ

/**
 * @brief         データ固有の ID です。
 *                ID を変更することで、同じデータでも別のデータとして扱われます。
 *                また、異なるデータに同じ ID を設定することで、同一データとして扱われます。
 */
struct DataId
{
    uint8_t raw[DataIdSize];
};

/**
 * @brief         送信データの構造体です。データ以外の付加情報が含まれます。
 */
struct SendDataDescription
{
    uint16_t dataSize;            //!< 送信データのサイズ
    uint8_t _reserve[6];
    DataId dataId;                //!< 送信データのID
    uint8_t data[SendDataSizeMax];//!< 送信データ
};
NN_STATIC_ASSERT(sizeof(SendDataDescription) == 1216);

/**
 * @brief         受信データの構造体です。データ以外の付加情報が含まれます。
 */
struct ReceiveDataDescription
{
    time::SteadyClockTimePoint receiveTimePoint;//!< データの受信タイミング
    uint16_t dataSize;                           //!< 受信データのサイズ
    uint8_t receiveTime;//[todo]移行完了でreserveにマージ
    uint8_t _reserve[5];
    uint8_t data[ReceiveDataSizeMax];            //!< 受信データ
};
NN_STATIC_ASSERT(sizeof(ReceiveDataDescription) == 1232);

}} // namespace nn::ndd
