﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//[todo]DataIdを隠蔽し、削除
#include <nn/ndd/ndd_Types.h>

//wlan::driver APIは、NetworkRequestが取得できていない状態では、呼んではいけない
//大半は、handlerのHandleStateTransition内で呼ばれないため、↑はケアされている
//ステート制御外から呼ぶ場合は注意
//[todo]

namespace nn { namespace ndd { namespace wlan { namespace driver {

void Initialize();
void Finalize();
void EnableNetwork();
void DisableNetwork();
void EnableSend(const void* pData, size_t size, DataId dataId);
void DisableSend();
void Sleep();
void Awake();
void DetectiveSleep(const void* pData, size_t size, DataId dataId);//[todo]Filterの追加
void DetectiveAwake();

void CreateReceiveEntry();
void DeleteReceiveEntry();
bool Receive(void* pBuffer, size_t* pSize, size_t size);//ブロッキング
void CancelReceive();

}}}}
