﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/ndd/ndd_Types.h>

namespace nn { namespace ndd {

struct File
{
public:
    static const size_t DataCountMax = 5;
    static uint16_t GetFileIndex(uint16_t dataIndex);
    static uint16_t GetDataIndexInFile(uint16_t dataIndex);
    ReceiveDataDescription rdd[DataCountMax];
};

class DummyFs
{
public:
    static const size_t FileCountMax = 10;
    void Write(const File& file, uint16_t index);
    void Read(File* pFile, uint16_t index) const;
private:
    File m_File[FileCountMax];
};

class Storage
{
public:
    Storage();
    void Write(const ReceiveDataDescription& rdd);
    void Read(ReceiveDataDescription* pRdd, uint16_t dataIndex);
    void Clear();
private:
    struct Cache
    {
        uint16_t fileIndex;
        uint8_t dataCount;
        File file;
    };

    Cache m_WriteCache;
    Cache m_ReadCache;
    DummyFs m_DummyFs;

    void ApplyWriteCache();
    void ChangeReadCache(uint16_t dataIndex);

    bool ReadFromWriteCache(ReceiveDataDescription* pRdd, uint16_t dataIndex);
    bool ReadFromReadCache(ReceiveDataDescription* pRdd, uint16_t dataIndex);
};

}}
