﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/ndd/ndd_Types.h>

namespace nn { namespace ndd {

namespace wlan { namespace receive {

//Handler向け
void Initialize();
void Start();
void Stop();

//Handler向け（テスト用途）
void Add(const ReceiveDataDescription& data);
void Clear();
void ClearDataIdFilter();

//Impl向け
uint32_t GetCurrentCounter();
uint32_t GetOldestCounter();
uint32_t GetNextCounter();
uint32_t GetRecentCounter(uint32_t counter, int count);
uint16_t GetAvailableCount(uint32_t counter);
bool Get(ReceiveDataDescription* pBuffer, uint32_t* pNextCounter, uint32_t counter);
int Get(ReceiveDataDescription buffer[], uint32_t* pNextCounter, int count, uint32_t counter);

int GetDeviceScanResult(ReceiveDataDescription buffer[], int count);
void ClearDeviceScanResult();
}}

}}
