﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/nd/service/nd_IService.sfdl.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace nd { namespace service {

/**
    TODO: アプリケーション・システムのスキャンの調停。
          例えばアプリケーションのスキャン実行中に（HOMEメニューに戻って ENCOUNTER を起動して）システムからスキャンが実行されようとした場合は
          1. アプリケーションのスキャン完了待ち
          2. アプリケーションから ndd に提供されたバッファの回収
          3. システムから渡されたバッファを ndd に渡す
          4. システムのスキャン開始
          のような処理が必要で、かつシステムでのスキャン中はアプリからの呼び出しを無視する。
*/
class ScanManager
{
public:
    explicit ScanManager(nn::MemoryResource& allocator) NN_NOEXCEPT;

    // TODO: アプリケーション向け

    // システム向け

    Result CreateScannerForSystem(nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>* pOut) NN_NOEXCEPT;
    void ReleaseScannerForSystem() NN_NOEXCEPT;
    void StartScanForSystem() NN_NOEXCEPT;
    void CancelScanForSystem() NN_NOEXCEPT;
    int GetScanResultForSystem(NeighborInfoForSystem out[], int outCount, const account::Uid& uid) NN_NOEXCEPT;
    os::SystemEvent& GetScanDoneEventForSystem() NN_NOEXCEPT;

    // 共通

    void HandleScanDoneEvent() NN_NOEXCEPT;

private:

    enum class State : Bit8
    {
        Idle,
        ScanningForSystem,
    } m_State = State::Idle;

    nn::MemoryResource& m_Allocator;
    mutable os::SdkMutex m_Mutex;

    // システム向け
    bool m_IsScannerForSystemCreated = false;
    os::SystemEvent m_ScanDoneEventForSystem{ os::EventClearMode_ManualClear, true };
};

}}} // ~nn::nd::service
