﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nd/nd_TypesForSystem.h>
#include <nn/settings/settings_Language.h>
#include <nn/time/time_SteadyClockTimePoint.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nd {

/**
    @brief      受信データ（本体機能向け）。
*/
struct NeighborInfoForSystem
{
    //! 受信時刻。
    time::SteadyClockTimePoint receivedTimePoint;
    //! 送信本体の本体設定言語。
    settings::LanguageCode systemLanguageCode;
    //! 送信者の識別子（本体ユーザーアカウント毎に固有）。
    LocalUserId localUserId;
    //! 送信者の識別子（ネットワークサービスアカウント毎に固有）。
    util::optional<NetworkUserId> networkUserId;
    //! 送信者のニックネーム。
    account::Nickname nickName;
    //! recentlyPlayedApplication に含まれる有効なアプリケーション ID の数。
    int recentlyPlayedApplicationCount;
    //! 送信者が最近遊んだアプリケーションのアプリケーション ID。[0, recentlyPlayedApplicationCount) の区間の ID が有効。
    ncm::ApplicationId recentlyPlayedApplication[RecentlyPlayedApplicationCountMax];
    //! systemData に含まれる有効なシステムデータのサイズ。
    size_t systemDataSize;
    //! システムデータ。[0, systemDataSize) の区間のデータが有効。
    Bit8 systemData[SystemDataSizeMax];
};

}} // ~namespace nn::nd
