﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief デバッグ向けの機能
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/ndd.h>

namespace nn { namespace nd {

//! @name デバッグ用の機能
//! @{

/**
    @brief      (デバッグ機能) 受信データを追加します。
    @param[in]  info 追加する受信データ
    @param[in]  count info の要素数
    @pre
                - info != nullptr
                - count > 0
    @details    デバッグ用に受信データを追加します。
*/
void AddReceivedNeighborInfoForSystemForDebug(NeighborInfoForSystem info[], int count) NN_NOEXCEPT;

/**
    @brief      (デバッグ機能) 指定したユーザーの送信データを取得します。
    @param[out] pOut 送信データ
    @param[in]  uid ユーザー
    @pre
                - pOut != nullptr
                - uid が指すユーザーが本体上に存在する
*/
void GetSendDataForDebug(ndd::SendDataDescription *pOut, const account::Uid& uid) NN_NOEXCEPT;

/**
    @brief      (デバッグ機能) 受信データをどこまで取得したかを表すカウンタ値を削除します。
    @param[in]  uid ユーザー
    @pre
                - uid が指すユーザーが本体上に存在する
*/
void ClearReceiveCounterForDebug(const account::Uid& uid) NN_NOEXCEPT;

//! @}

}} // ~namespace nn::nd
