﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/migration/detail/migration_MigrationList.h>

namespace nn { namespace migration { namespace user {

// SystemSaveData を含めた個数上限
const size_t UserMigrationSaveDataCountMax = 48 * 1024;
const size_t UserMigrationListBytesMax = sizeof(detail::MigrationListHeader) + UserMigrationSaveDataCountMax * sizeof(detail::DataInfo);

const size_t UserMigrationRelatedApplicationCountMax = 4 * 1024;

}}} // ~namespace nn::migration::user
