﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/migration/idc/migration_CommandTypes.h>

namespace nn { namespace migration { namespace idc { namespace detail {

template <typename KeyEncryptorType, typename MessageEncryptorType, size_t userCommandBlockSize, int keyStretchingIteration>
struct EncryptionPolicy
{
    typedef KeyEncryptorType        KeyEncryptor;
    typedef MessageEncryptorType    MessageEncryptor;
    static const size_t             UserCommandBlockSize = userCommandBlockSize;
    static const int                KeyStretchingIteration = keyStretchingIteration;
    static const KeyExchangeCommandConfig::Salt KeyStretchingSalt;
};

}}}}

#include <nn/migration/idc/migration_KeyExchangeCommandEncryptor.h>
#include <nn/migration/idc/migration_MessageEncryptor.h>

namespace nn { namespace migration { namespace idc { namespace detail {

// TORIAEZU: BlockSize を適当に設定。

typedef EncryptionPolicy<DebugKeyExchangeCommandEncryptor, DebugMessageEncryptor, 1024, 1000> DebugEncryptionPolicy;

#if defined (NN_BUILD_CONFIG_OS_HORIZON)
typedef EncryptionPolicy<KeyExchangeCommandEncryptor, MessageEncryptor, 1024, 1000> DefaultEncryptionPolicy;
#else
typedef DebugEncryptionPolicy DefaultEncryptionPolicy;
#endif

}}}}
