﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/friends/friends_ApiAdmin.h>
#include <nn/migration/detail/migration_SharedResource.h>
#include <nn/socket/socket_SystemConfig.h>

namespace nn { namespace migration { namespace detail {

class SubsystemInitializer
{
protected:
    typedef socket::SystemConfigWithMemory<2, 0, 128 * 1024,       1024, 0, 0, 0, 0, 2, 32 * 1024> SocketConfigForSender;
    typedef socket::SystemConfigWithMemory<2, 0,       1024, 128 * 1024, 0, 0, 0, 0, 2, 32 * 1024> SocketConfigForReceiver;
    NN_STATIC_ASSERT(sizeof(SocketConfigForSender) == sizeof(SocketConfigForReceiver));
    NN_STATIC_ASSERT(std::alignment_of<SocketConfigForSender>::value == std::alignment_of<SocketConfigForReceiver>::value);

public:
    typedef std::aligned_storage<sizeof(SocketConfigForReceiver), std::alignment_of<SocketConfigForReceiver>::value>::type SocketBuffer;

private:
    static Counter s_Counter;
    static os::Mutex s_Lock;
    static bool s_IsAttached;
    static SocketBuffer* s_Buffer;

public:
    static void AttachSocketBuffer(SocketBuffer& buffer) NN_NOEXCEPT;

protected:
    static UniqueResource<SocketBuffer*> AcquireSocketConfigBuffer() NN_NOEXCEPT;

private:
    account::Uid m_Uids[account::UserCountMax];
    int m_UidCount;
    friends::DaemonSuspension m_FriendsSuspension;

public:
    SubsystemInitializer() NN_NOEXCEPT;
    ~SubsystemInitializer() NN_NOEXCEPT;
};

class ClientSubsystemInitializer
    : SubsystemInitializer
{
private:
    UniqueResource<SocketBuffer*> m_Buffer;
    SocketConfigForReceiver* m_pConfig;

public:
    ClientSubsystemInitializer() NN_NOEXCEPT;
    ~ClientSubsystemInitializer() NN_NOEXCEPT;
};

class ServerSubsystemInitializer
    : SubsystemInitializer
{
private:
    UniqueResource<SocketBuffer*> m_Buffer;
    SocketConfigForSender* m_pConfig;

public:
    ServerSubsystemInitializer() NN_NOEXCEPT;
    ~ServerSubsystemInitializer() NN_NOEXCEPT;
};

}}} // ~namespace nn::migration::detail
