﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTransfer.h>
#include <nn/migration/detail/migration_MigrationList.h>
#include <nn/migration/detail/migration_MigrationProgress.h>
#include <nn/migration/detail/migration_IdcClient.h>
#include <nn/migration/detail/migration_IdcServer.h>

namespace nn { namespace migration { namespace detail {

class SaveDataExporter
{
private:
    struct Resource
    {
        char initialData[fs::SaveDataExporter::InitialDataSize];
    };

    IdcServerBase& m_Server;
    Resource* m_pResource;

    std::unique_ptr<fs::SaveDataExporter> m_pImpl;
    DataInfo m_DataInfo;
    uint64_t m_Cursor;

public:
    typedef std::aligned_storage<sizeof(Resource), std::alignment_of<Resource>::value>::type ResourceStorage;

    SaveDataExporter(IdcServerBase& server, ResourceStorage& workBuffer) NN_NOEXCEPT;

    Result Setup(const DataInfo& dataInfo) NN_NOEXCEPT;
    size_t Export(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    size_t GetRemainingSize() const NN_NOEXCEPT;
};

class SaveDataImporter
{
private:
    struct Resource
    {
        char initialData[fs::SaveDataExporter::InitialDataSize];
    };

    const account::Uid m_Uid;
    const DataInfo m_DataInfo;

    IdcClientBase* m_pClient;
    Resource* m_pResource;

    ProgressMonitor& m_ProgressMonitor;

    uint64_t m_Cursor;
    std::unique_ptr<fs::SaveDataImporter> m_pImpl;

public:
    typedef std::aligned_storage<sizeof(Resource), std::alignment_of<Resource>::value>::type ResourceStorage;

    SaveDataImporter(const DataInfo& dataInfo, ProgressMonitor& progressMonitor) NN_NOEXCEPT;
    SaveDataImporter(const account::Uid& uid, const DataInfo& dataInfo, ProgressMonitor& progressMonitor) NN_NOEXCEPT;

    void Initialize(IdcClientBase& client, ResourceStorage& workBuffer) NN_NOEXCEPT;

    fs::SaveDataId GetSaveDataId() const NN_NOEXCEPT;
    size_t GetRemainingSize() const NN_NOEXCEPT;
    Result Update(const void* data, size_t dataSize) NN_NOEXCEPT;
    Result Complete() NN_NOEXCEPT;
};

}}} // ~namespace nn::migration::detail
