﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/migration/migration_Types.h>
#include <nn/migration/detail/migration_MigrationList.h>

namespace nn { namespace migration { namespace detail {

struct SimpleMigrationProgress
{
    TransferInfo total;
    TransferInfo current;

    void Reset(const TransferInfo& v) NN_NOEXCEPT
    {
        total = v;
        current.count = 0;
        current.sizeInBytes = 0u;
    }
};

class ProgressMonitor
{
public:
    virtual void Start(const DataInfo& dataInfo) NN_NOEXCEPT = 0;
    virtual void Update(size_t dataSize) NN_NOEXCEPT = 0;
    virtual void End() NN_NOEXCEPT = 0;
};

}}} // ~namespace nn::migration::detail
