﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/idc/migration_SocketConnection.h>
#include <nn/socket/socket_Types.h>

namespace nn { namespace migration { namespace detail {

Result SetupConnectionPort(int acceptSocket, in_addr inAddr, uint16_t port) NN_NOEXCEPT;
Result SetupConnectionPort(int acceptSocket, const char* inAddr, uint16_t port) NN_NOEXCEPT;
Result SetupConnectionPort(int acceptSocket, const ldn::Ipv4Address& inAddr, uint16_t port) NN_NOEXCEPT;
Result WaitConnection(idc::SocketConnection* pOut, int acceptSocket, int timeoutSeconds, const Cancellable* pCancellable) NN_NOEXCEPT;

Result ConnectToPort(int clientSocket, in_addr inAddr, uint16_t port) NN_NOEXCEPT;
Result ConnectToPort(int clientSocket, const char* inAddr, uint16_t port) NN_NOEXCEPT;
Result ConnectToPort(int clientSocket, const ldn::Ipv4Address& inAddr, uint16_t port) NN_NOEXCEPT;

}}} // ~namespace nn::migration::detail
