﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/detail/migration_LoginSession.h>

namespace nn { namespace migration { namespace detail {

struct FsKeySeed
{
    Bit8 data[512]; // バイナリ
};
struct FsChallenge
{
    Bit8 data[16]; // バイナリ
};
struct FsKeySeedDigest
{
    Bit8 data[32]; // バイナリ
};
struct OnetimeToken
{
    char data[64 + 1]; // null 終端される
};

struct DeviceAuthenticationToken
{
    char data[1024 + 1];
};
struct NsaIdToken
{
    char data[account::NetworkServiceAccountIdTokenLengthMax + 1]; // null 終端される
};

struct MigrationAuthenticationData {
    FsKeySeed fsKeySeed;
    FsKeySeedDigest fsKeySeedDigest;
};

class Authenticator
{
private:
    struct Resource
    {
        NsaIdToken nsaIdToken;
        std::aligned_storage<1024 * 16, std::alignment_of<std::max_align_t>::value>::type workBuffer;

        union
        {
            struct
            {
                MigrationAuthenticationData authData;
                OnetimeToken onetimeToken;

            } source;
            struct
            {
                MigrationAuthenticationData authData;
            } destination;
        } u;
    };
    NN_STATIC_ASSERT(std::alignment_of<Resource>::value == std::alignment_of<std::max_align_t>::value);

public:
    typedef std::aligned_storage<sizeof(Resource), std::alignment_of<Resource>::value>::type WorkBuffer;

    static Result PrepareNsaIdToken(LoginSessionBase& login, const Cancellable* pCancellable) NN_NOEXCEPT;

    static Result Authenticate(
        FsKeySeed* pOutFsKeySeed, FsKeySeedDigest* pOutDigest, OnetimeToken* pOutOtt,
        LoginSessionBase& login, const FsChallenge& fsChallenge,
        void* workBuffer, size_t workBufferSize, const Cancellable* pCancellable) NN_NOEXCEPT;

    static Result AuthenticateWithOneTimeCode(
        FsKeySeed* pOutFsKeySeed, FsKeySeedDigest* pOutDigest,
        LoginSessionBase& login, const FsChallenge& fsChallenge, const OnetimeToken& ott,
        void* workBuffer, size_t workBufferSize, const Cancellable* pCancellable) NN_NOEXCEPT;
};

}}} // ~namespace nn::migration::detail
