﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace manu { // NOLINT(whitespace/braces)

class IManu;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IManu, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IManu)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUfio, (::std::uint32_t portNumber))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFileSize, (::nn::sf::Out<::std::uint64_t> pOutData, const ::nn::sf::InArray<char>& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadFromHost, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t readSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteToHost, (const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t writeSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUsbTransfer, (::std::uint32_t portNumber))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UsbRead, (::nn::sf::Out<::std::uint64_t> pOutSuccessReadSize, const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, ::std::uint64_t readSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UsbWrite, (::nn::sf::Out<::std::uint64_t> pOutSuccessWriteSize, const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, ::std::uint64_t writeSize))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IManu)

        void InitializeForUfio(::std::uint32_t portNumber) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InitializeForUfio, (portNumber));
        }

        ::nn::Result GetFileSize(::nn::sf::Out<::std::uint64_t> pOutData, const ::nn::sf::InArray<char>& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFileSize, (pOutData, path));
        }

        ::nn::Result ReadFromHost(const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t readSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadFromHost, (pOutBuffer, bufferSize, path, offset, readSize));
        }

        ::nn::Result WriteToHost(const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t writeSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteToHost, (pBuffer, bufferSize, path, offset, writeSize));
        }

        void InitializeForUsbTransfer(::std::uint32_t portNumber) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InitializeForUsbTransfer, (portNumber));
        }

        ::nn::Result UsbRead(::nn::sf::Out<::std::uint64_t> pOutSuccessReadSize, const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, ::std::uint64_t readSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UsbRead, (pOutSuccessReadSize, pOutBuffer, bufferSize, readSize));
        }

        ::nn::Result UsbWrite(::nn::sf::Out<::std::uint64_t> pOutSuccessWriteSize, const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, ::std::uint64_t writeSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UsbWrite, (pOutSuccessWriteSize, pBuffer, bufferSize, writeSize));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IManu
    {
    public:
        void InitializeForUfio(std::uint32_t portNumber) NN_NOEXCEPT;
        nn::Result GetFileSize(nn::sf::Out<std::uint64_t> pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT;
        nn::Result ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t readSize) NN_NOEXCEPT;
        nn::Result WriteToHost(const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t writeSize) NN_NOEXCEPT;
        void InitializeForUsbTransfer(std::uint32_t portNumber) NN_NOEXCEPT;
        nn::Result UsbRead(nn::sf::Out<std::uint64_t> pOutSuccessReadSize, const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, std::uint64_t readSize) NN_NOEXCEPT;
        nn::Result UsbWrite(nn::sf::Out<std::uint64_t> pOutSuccessWriteSize, const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, std::uint64_t writeSize) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    void InitializeForUfio(std::uint32_t portNumber) NN_NOEXCEPT;
    nn::Result GetFileSize(nn::sf::Out<std::uint64_t> pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT;
    nn::Result ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t readSize) NN_NOEXCEPT;
    nn::Result WriteToHost(const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t writeSize) NN_NOEXCEPT;
    void InitializeForUsbTransfer(std::uint32_t portNumber) NN_NOEXCEPT;
    nn::Result UsbRead(nn::sf::Out<std::uint64_t> pOutSuccessReadSize, const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, std::uint64_t readSize) NN_NOEXCEPT;
    nn::Result UsbWrite(nn::sf::Out<std::uint64_t> pOutSuccessWriteSize, const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, std::uint64_t writeSize) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::manu::IManu))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUfio, (::std::uint32_t portNumber))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InitializeForUfio, (portNumber));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFileSize, (::nn::sf::Out<::std::uint64_t> pOutData, const ::nn::sf::InArray<char>& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFileSize, (pOutData, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFromHost, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t readSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadFromHost, (pOutBuffer, bufferSize, path, offset, readSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteToHost, (const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t writeSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteToHost, (pBuffer, bufferSize, path, offset, writeSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUsbTransfer, (::std::uint32_t portNumber))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InitializeForUsbTransfer, (portNumber));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UsbRead, (::nn::sf::Out<::std::uint64_t> pOutSuccessReadSize, const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, ::std::uint64_t readSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UsbRead, (pOutSuccessReadSize, pOutBuffer, bufferSize, readSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UsbWrite, (::nn::sf::Out<::std::uint64_t> pOutSuccessWriteSize, const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, ::std::uint64_t writeSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UsbWrite, (pOutSuccessWriteSize, pBuffer, bufferSize, writeSize));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::manu::IManu>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::manu::IManu))

    // void InitializeForUfio(std::uint32_t portNumber) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeForUfio)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portNumber, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (portNumber))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portNumber)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeForUfio)

    // nn::Result GetFileSize(nn::sf::Out<std::uint64_t> pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFileSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutData, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutData))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFileSize)

    // nn::Result ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t readSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadFromHost)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 1, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutBuffer, path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(readSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (bufferSize, offset, readSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadFromHost)

    // nn::Result WriteToHost(const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t writeSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteToHost)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 1, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pBuffer, path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(writeSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (bufferSize, offset, writeSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(writeSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteToHost)

    // void InitializeForUsbTransfer(std::uint32_t portNumber) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeForUsbTransfer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(portNumber, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (portNumber))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(portNumber)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeForUsbTransfer)

    // nn::Result UsbRead(nn::sf::Out<std::uint64_t> pOutSuccessReadSize, const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, std::uint64_t readSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UsbRead)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(readSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bufferSize, readSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSuccessReadSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSuccessReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSuccessReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(readSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UsbRead)

    // nn::Result UsbWrite(nn::sf::Out<std::uint64_t> pOutSuccessWriteSize, const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, std::uint64_t writeSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UsbWrite)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(writeSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bufferSize, writeSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSuccessWriteSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSuccessWriteSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSuccessWriteSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(writeSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UsbWrite)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::manu::IManu, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::manu::IManu))

    // void InitializeForUfio(std::uint32_t portNumber) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUfio, (::std::uint32_t portNumber))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeForUfio)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portNumber)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeForUfio)
    }

    // nn::Result GetFileSize(nn::sf::Out<std::uint64_t> pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFileSize, (::nn::sf::Out<::std::uint64_t> pOutData, const ::nn::sf::InArray<char>& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFileSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFileSize)
    }

    // nn::Result ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t readSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFromHost, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t readSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadFromHost)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadFromHost)
    }

    // nn::Result WriteToHost(const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, const nn::sf::InArray<char>& path, std::uint64_t offset, std::uint64_t writeSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteToHost, (const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, const ::nn::sf::InArray<char>& path, ::std::uint64_t offset, ::std::uint64_t writeSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteToHost)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(writeSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteToHost)
    }

    // void InitializeForUsbTransfer(std::uint32_t portNumber) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InitializeForUsbTransfer, (::std::uint32_t portNumber))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeForUsbTransfer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(portNumber)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeForUsbTransfer)
    }

    // nn::Result UsbRead(nn::sf::Out<std::uint64_t> pOutSuccessReadSize, const nn::sf::OutBuffer& pOutBuffer, std::uint64_t bufferSize, std::uint64_t readSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UsbRead, (::nn::sf::Out<::std::uint64_t> pOutSuccessReadSize, const ::nn::sf::OutBuffer& pOutBuffer, ::std::uint64_t bufferSize, ::std::uint64_t readSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UsbRead)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSuccessReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(readSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UsbRead)
    }

    // nn::Result UsbWrite(nn::sf::Out<std::uint64_t> pOutSuccessWriteSize, const nn::sf::InBuffer& pBuffer, std::uint64_t bufferSize, std::uint64_t writeSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UsbWrite, (::nn::sf::Out<::std::uint64_t> pOutSuccessWriteSize, const ::nn::sf::InBuffer& pBuffer, ::std::uint64_t bufferSize, ::std::uint64_t writeSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UsbWrite)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSuccessWriteSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(writeSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UsbWrite)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::manu::IManu>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::manu::IManu))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeForUfio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeForUfio)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portNumber)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFileSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFileSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadFromHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadFromHost)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(readSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteToHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteToHost)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(writeSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeForUsbTransfer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeForUsbTransfer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(portNumber)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UsbRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UsbRead)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSuccessReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(readSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UsbWrite)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UsbWrite)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSuccessWriteSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(writeSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeForUfio)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFileSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadFromHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteToHost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeForUsbTransfer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UsbRead)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UsbWrite)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::manu::IManu))
