﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/ldn_Ipv4Address.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace ldn
{
    //! @name システム専用の API
    //! @{

    /**
     * @brief         ローカル通信ライブラリを初期化します。
     *
     * @retresult
     *  @handleresult{ResultSuccess}
     *  @handleresult{ResultDeviceDisabled}
     *  @handleresult{ResultDeviceOccupied}
     * @endretresult
     *
     * @pre
     * - GetState() == @ref State_None
     *
     * @post
     * - GetState() == @ref State_Initialized
     *
     * @details
     * @ref Initialize 関数と同等の処理を行います。ただし、通信機能の使用が競合した場合、
     * @ref InitializeSystem 関数で開始するローカル通信の方が優先されます。
     *
     * 具体的には、@ref Initialize 関数でローカル通信を開始した場合、
     * 後から別の利用者が InitializeSystem 関数を呼び出すと、前者のローカル通信は中断され、
     * 後者が新しくローカル通信を開始することができます。
     *
     * これに対して、最初に InitializeSystem 関数でローカル通信を開始した場合、
     * 後から別の利用者が @ref Initialize 関数を呼びだしても、
     * 前者のローカル通信が中断されることはありません。
     * なお、この状態でさらに @ref InitializeSystem 関数を呼びだした場合であっても、
     * 最初にローカル通信を開始した利用者が優先されるため、
     * ローカル通信が中断されることはありません。
     */
    Result InitializeSystem() NN_NOEXCEPT;

    /**
     * @brief         ローカル通信ライブラリを解放します。
     *
     * @pre
     * - GetState() != @ref State_None
     *
     * @post
     * - GetState() == @ref State_None
     *
     * @details
     * ローカル通信ライブラリを解放します。
     * この関数の実行によって占有していた通信デバイスが解放され、他の通信機能を利用可能になります。
     * @ref InitializeSystem 関数でローカル通信を開始した場合、
     * @ref Finalize 関数の代わりに FinalizeSystem 関数を使用してください。
     */
    void FinalizeSystem() NN_NOEXCEPT;

    //! @}

}} // end of namespace nn::ldn
