﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ldn/ldn_Types.h>

namespace nn { namespace ldn { namespace detail
{
    //! 無効なコンテキストです。
    const int InvalidContextId = -1;

    // コンテキストの実体です。
    struct Context
    {
        Bit64 pid;
        Result discardReason;
        int32_t contextId;
        int8_t disconnectReason;
        NN_PADDING7;
        NN_PADDING8;
    };
    NN_STATIC_ASSERT(sizeof(Context) == 32);

    /**
     * @brief           新しいコンテキストを生成します。
     * @return          新しく生成されたコンテキストの識別子です。
     */
    int CreateContext() NN_NOEXCEPT;

    /**
     * @brief           コンテキストを破棄します。
     * @param[in]       contextId       対象のコンテキストの識別子です。
     */
    void DestroyContext(int contextId) NN_NOEXCEPT;

    /**
     * @brief           コンテキストの実体を取得します。
     * @param[in]       contextId       対象のコンテキストの識別子です。
     */
    Context* GetContext(int contextId) NN_NOEXCEPT;

}}} // namespace nn::ldn::detail
