﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail { namespace impl
{
}}}} // namespace nn::ldn::detail::impl

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         指定された数値を 16 進文字に変換します。
     *
     * @param[in]     n             対象の数値です。
     *
     * @return        対応する 16 進文字です。
     *
     * @pre
     *                - 0 <= n && n < 16
     */
    char ConvertToHexChar(int n) NN_NOEXCEPT;

    /**
     * @brief         指定されたバイナリデータを 16 進文字列に変換します。
     *
     * @param[out]    outBuffer     16 進文字列の出力先です。 0 で終端されます。
     * @param[in]     bufferSize    @a outBuffer のバッファサイズです。
     * @param[in]     input         対象のバイナリデータです。
     * @param[in]     inputSize     @a input のバイトサイズです。
     *
     * @return        出力サイズです。終端文字を含みません。
     *
     * @pre
     *                - 0 <= n && n < 16
     */
    size_t ConvertToHexString(void* outBuffer, size_t bufferSize,
                              const void* input, size_t inputSize) NN_NOEXCEPT;

    /**
     * @brief           文字列化のヘルパです。
     * @tparam          LENGTH      最大文字数です。
     */
    template <int LENGTH>
    class StringizeHelper
    {
    public:

        template <typename T>
        const char* ToString(const T& value) NN_NOEXCEPT
        {
            ConvertToString(value, m_Buffer, sizeof(m_Buffer));
            return m_Buffer;
        }

    private:

        NN_STATIC_ASSERT(0 < LENGTH);
        char m_Buffer[LENGTH + 1];
    };

    /**
     * @brief           StringizeHelper を定義します。
     */
    #define NN_LDN_STRINGIZE_HELPER(name, length) \
        ::nn::ldn::detail::StringizeHelper<length> name;\
        NN_UNUSED(name)

}}} // end of namespace nn::ldn::detail
