﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         製品機か否かの判定です。
     * @return        製品機であれば true を返します。
     */
    bool IsProductionEnvironment() NN_NOEXCEPT;

    /**
     * @brief         AES の鍵を生成します。
     * @param[out]    outKey        AES 鍵の出力先です。
     * @param[in]     keySource     AES 鍵の生成に使用するメッセージです。
     * @param[in]     keySourceSize keySource のバイトサイズです。
     * @param[in]     kekSource     KEK の生成に使用するメッセージです。
     * @param[in]     kekSourceSize kekSource のバイトサイズです。
     * @pre
     * - outKey != nullptr
     * - kekSource != nullptr
     * - keySourceSize == 16
     */
    void GenerateAesKey(
        Bit8 (&outKey)[16], const void* keySource, size_t keySourceSize,
        const void* kekSource, size_t kekSourceSize) NN_NOEXCEPT;

}}} // end of namespace nn::ldn::detail
