﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ldn/detail/Service/ldn_Service.sfdl.h>

namespace nn { namespace ldn { namespace detail
{
    class UserServiceCreator
    {
    public:

        explicit UserServiceCreator() NN_NOEXCEPT;

        ~UserServiceCreator() NN_NOEXCEPT;

        Result CreateUserLocalCommunicationService(
            nn::sf::Out<nn::sf::SharedPointer<IUserLocalCommunicationService>> pOutService
        ) NN_NOEXCEPT;
    };

    class MonitorServiceCreator
    {
    public:

        explicit MonitorServiceCreator() NN_NOEXCEPT;

        ~MonitorServiceCreator() NN_NOEXCEPT;

        Result CreateMonitorService(
            nn::sf::Out<nn::sf::SharedPointer<IMonitorService>> pOutService
        ) NN_NOEXCEPT;
    };

    class SystemServiceCreator
    {
    public:

        explicit SystemServiceCreator() NN_NOEXCEPT;

        ~SystemServiceCreator() NN_NOEXCEPT;

        Result CreateSystemLocalCommunicationService(
            nn::sf::Out<nn::sf::SharedPointer<ISystemLocalCommunicationService>> pOutService
        ) NN_NOEXCEPT;
    };

}}} // namespace nn::ldn::detail
