﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ldn/ldn_Ipv4Address.h>
#include <nn/ldn/ldn_MacAddress.h>
#include <nn/ldn/ldn_PrivateTypes.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

class ILocalCommunicationService;

class IMonitorService;

class IMonitorServiceCreator;

class IStateGetService;

class ISystemLocalCommunicationService;

class ISystemServiceCreator;

class IUserLocalCommunicationService;

class IUserServiceCreator;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IStateGetService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IStateGetService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> pOutState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfo, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIpv4Address, (::nn::sf::Out<::nn::ldn::Ipv4Address> pOutAddress, ::nn::sf::Out<::nn::ldn::SubnetMask> pOutMask))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDisconnectReason, (::nn::sf::Out<::std::int16_t> pOutReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSecurityParameter, (::nn::sf::Out<::nn::ldn::SecurityParameter> pOutSecurityParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkConfig, (::nn::sf::Out<::nn::ldn::NetworkConfig> pOutNetworkConfig))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IStateGetService)

        ::nn::Result GetState(::nn::sf::Out<::nn::Bit32> pOutState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pOutState));
        }

        ::nn::Result GetNetworkInfo(::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkInfo, (pOutNetwork));
        }

        ::nn::Result GetIpv4Address(::nn::sf::Out<::nn::ldn::Ipv4Address> pOutAddress, ::nn::sf::Out<::nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIpv4Address, (pOutAddress, pOutMask));
        }

        ::nn::Result GetDisconnectReason(::nn::sf::Out<::std::int16_t> pOutReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDisconnectReason, (pOutReason));
        }

        ::nn::Result GetSecurityParameter(::nn::sf::Out<::nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSecurityParameter, (pOutSecurityParameter));
        }

        ::nn::Result GetNetworkConfig(::nn::sf::Out<::nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkConfig, (pOutNetworkConfig));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IStateGetService
    {
    public:
        nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
        nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
        nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
        nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
        nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
        nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
    nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
    nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
    nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
    nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
    nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ldn::detail::IStateGetService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> pOutState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pOutState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfo, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkInfo, (pOutNetwork));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIpv4Address, (::nn::sf::Out<::nn::ldn::Ipv4Address> pOutAddress, ::nn::sf::Out<::nn::ldn::SubnetMask> pOutMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIpv4Address, (pOutAddress, pOutMask));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisconnectReason, (::nn::sf::Out<::std::int16_t> pOutReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDisconnectReason, (pOutReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSecurityParameter, (::nn::sf::Out<::nn::ldn::SecurityParameter> pOutSecurityParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSecurityParameter, (pOutSecurityParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkConfig, (::nn::sf::Out<::nn::ldn::NetworkConfig> pOutNetworkConfig))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkConfig, (pOutNetworkConfig));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::IStateGetService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ldn::detail::IStateGetService))

    // nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutNetwork, 0, (::nn::sf::Out<::nn::ldn::NetworkInfo>), 1152, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutNetwork))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNetwork)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkInfo)

    // nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIpv4Address)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddress, (::nn::ldn::Ipv4Address), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMask, (::nn::ldn::SubnetMask), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutAddress, pOutMask))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIpv4Address)

    // nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDisconnectReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReason, (::std::int16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDisconnectReason)

    // nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSecurityParameter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSecurityParameter, (::nn::ldn::SecurityParameter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSecurityParameter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSecurityParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSecurityParameter)

    // nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutNetworkConfig, (::nn::ldn::NetworkConfig), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutNetworkConfig))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNetworkConfig)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkConfig)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkInfo), 1152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::Ipv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SubnetMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityParameter), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkConfig), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::IStateGetService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ldn::detail::IStateGetService))

    // nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> pOutState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfo, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNetwork)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkInfo)
    }

    // nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIpv4Address, (::nn::sf::Out<::nn::ldn::Ipv4Address> pOutAddress, ::nn::sf::Out<::nn::ldn::SubnetMask> pOutMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIpv4Address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIpv4Address)
    }

    // nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDisconnectReason, (::nn::sf::Out<::std::int16_t> pOutReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDisconnectReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDisconnectReason)
    }

    // nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSecurityParameter, (::nn::sf::Out<::nn::ldn::SecurityParameter> pOutSecurityParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSecurityParameter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSecurityParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSecurityParameter)
    }

    // nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkConfig, (::nn::sf::Out<::nn::ldn::NetworkConfig> pOutNetworkConfig))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNetworkConfig)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkConfig)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::IStateGetService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ldn::detail::IStateGetService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutNetwork)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIpv4Address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIpv4Address)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDisconnectReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDisconnectReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSecurityParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSecurityParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSecurityParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutNetworkConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIpv4Address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDisconnectReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSecurityParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkConfig)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::IStateGetService))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILocalCommunicationService, (::nn::ldn::detail::IStateGetService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILocalCommunicationService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutReadableHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfoAndHistory, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork, const ::nn::sf::OutArray<::nn::ldn::NodeLatestUpdate>& outUpdates))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Scan, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ScanPrivate, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessControllerRestriction, (::nn::Bit32 restriction))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenAccessPoint)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseAccessPoint)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetwork, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, const ::nn::sf::InArray<::nn::ldn::AddressEntry>& entries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DestroyNetwork)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Reject, (::nn::ldn::Ipv4Address address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAdvertiseData, (const ::nn::sf::InBuffer& data))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetStationAcceptPolicy, (::nn::Bit8 policy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddAcceptFilterEntry, (::nn::ldn::MacAddress station))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearAcceptFilter)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenStation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseStation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::ldn::NetworkInfo& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConnectPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILocalCommunicationService)

        ::nn::Result GetStateChangeEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (pOutReadableHandle));
        }

        ::nn::Result GetNetworkInfoAndHistory(::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork, const ::nn::sf::OutArray<::nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkInfoAndHistory, (pOutNetwork, outUpdates));
        }

        ::nn::Result Scan(const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Scan, (pOutScanResultArray, pOutCount, filter, channel));
        }

        ::nn::Result ScanPrivate(const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ScanPrivate, (pOutScanResultArray, pOutCount, filter, channel));
        }

        ::nn::Result SetWirelessControllerRestriction(::nn::Bit32 restriction) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWirelessControllerRestriction, (restriction));
        }

        ::nn::Result OpenAccessPoint() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenAccessPoint);
        }

        ::nn::Result CloseAccessPoint() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseAccessPoint);
        }

        ::nn::Result CreateNetwork(const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateNetwork, (network, security, user));
        }

        ::nn::Result CreateNetworkPrivate(const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, const ::nn::sf::InArray<::nn::ldn::AddressEntry>& entries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateNetworkPrivate, (network, securityConfig, securityParam, user, entries));
        }

        ::nn::Result DestroyNetwork() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DestroyNetwork);
        }

        ::nn::Result Reject(::nn::ldn::Ipv4Address address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Reject, (address));
        }

        ::nn::Result SetAdvertiseData(const ::nn::sf::InBuffer& data) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAdvertiseData, (data));
        }

        ::nn::Result SetStationAcceptPolicy(::nn::Bit8 policy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetStationAcceptPolicy, (policy));
        }

        ::nn::Result AddAcceptFilterEntry(::nn::ldn::MacAddress station) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddAcceptFilterEntry, (station));
        }

        ::nn::Result ClearAcceptFilter() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearAcceptFilter);
        }

        ::nn::Result OpenStation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenStation);
        }

        ::nn::Result CloseStation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseStation);
        }

        ::nn::Result Connect(const ::nn::ldn::NetworkInfo& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (network, security, user, version, option));
        }

        ::nn::Result ConnectPrivate(const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConnectPrivate, (network, securityConfig, securityParam, user, version, option));
        }

        ::nn::Result Disconnect() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Disconnect);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILocalCommunicationService : public ::nn::ldn::detail::IStateGetService
    {
    public:
        nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT;
        nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT;
        nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
        nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
        nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT;
        nn::Result OpenAccessPoint() NN_NOEXCEPT;
        nn::Result CloseAccessPoint() NN_NOEXCEPT;
        nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT;
        nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT;
        nn::Result DestroyNetwork() NN_NOEXCEPT;
        nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT;
        nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT;
        nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT;
        nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT;
        nn::Result ClearAcceptFilter() NN_NOEXCEPT;
        nn::Result OpenStation() NN_NOEXCEPT;
        nn::Result CloseStation() NN_NOEXCEPT;
        nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
        nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
        nn::Result Disconnect() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
    nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
    nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
    nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
    nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
    nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT;
    nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT;
    nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT;
    nn::Result OpenAccessPoint() NN_NOEXCEPT;
    nn::Result CloseAccessPoint() NN_NOEXCEPT;
    nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT;
    nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT;
    nn::Result DestroyNetwork() NN_NOEXCEPT;
    nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT;
    nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT;
    nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT;
    nn::Result ClearAcceptFilter() NN_NOEXCEPT;
    nn::Result OpenStation() NN_NOEXCEPT;
    nn::Result CloseStation() NN_NOEXCEPT;
    nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result Disconnect() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::ldn::detail::ILocalCommunicationService), (::nn::ldn::detail::IStateGetService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutReadableHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateChangeEvent, (pOutReadableHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfoAndHistory, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork, const ::nn::sf::OutArray<::nn::ldn::NodeLatestUpdate>& outUpdates))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkInfoAndHistory, (pOutNetwork, outUpdates));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Scan, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Scan, (pOutScanResultArray, pOutCount, filter, channel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ScanPrivate, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ScanPrivate, (pOutScanResultArray, pOutCount, filter, channel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessControllerRestriction, (::nn::Bit32 restriction))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWirelessControllerRestriction, (restriction));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenAccessPoint)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenAccessPoint);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseAccessPoint)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseAccessPoint);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetwork, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateNetwork, (network, security, user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, const ::nn::sf::InArray<::nn::ldn::AddressEntry>& entries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateNetworkPrivate, (network, securityConfig, securityParam, user, entries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyNetwork)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DestroyNetwork);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Reject, (::nn::ldn::Ipv4Address address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Reject, (address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAdvertiseData, (const ::nn::sf::InBuffer& data))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAdvertiseData, (data));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStationAcceptPolicy, (::nn::Bit8 policy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetStationAcceptPolicy, (policy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddAcceptFilterEntry, (::nn::ldn::MacAddress station))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddAcceptFilterEntry, (station));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearAcceptFilter)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearAcceptFilter);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenStation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenStation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseStation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseStation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::ldn::NetworkInfo& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (network, security, user, version, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConnectPrivate, (network, securityConfig, securityParam, user, version, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Disconnect);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::ILocalCommunicationService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::ldn::detail::ILocalCommunicationService), (::nn::ldn::detail::IStateGetService))

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReadableHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateChangeEvent)

    // nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkInfoAndHistory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutNetwork, 0, (::nn::sf::Out<::nn::ldn::NetworkInfo>), 1152, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUpdates, 1, (const ::nn::sf::OutArray<::nn::ldn::NodeLatestUpdate>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutNetwork, outUpdates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNetwork), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUpdates)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkInfoAndHistory)

    // nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Scan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutScanResultArray, 0, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutScanResultArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::int16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::ldn::ScanFilter), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (channel, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(104)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutScanResultArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Scan)

    // nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ScanPrivate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutScanResultArray, 0, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutScanResultArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::int16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::ldn::ScanFilter), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (channel, filter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(104)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutScanResultArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ScanPrivate)

    // nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWirelessControllerRestriction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(restriction, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (restriction))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(restriction)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWirelessControllerRestriction)

    // nn::Result OpenAccessPoint() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAccessPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAccessPoint)

    // nn::Result CloseAccessPoint() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseAccessPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseAccessPoint)

    // nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateNetwork)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(security, (::nn::ldn::SecurityConfig), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::ldn::UserConfig), 68)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(network, (::nn::ldn::NetworkConfig), 120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (security, user, network))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(152)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(network), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(security), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateNetwork)

    // nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateNetworkPrivate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(entries, 0, (const ::nn::sf::InArray<::nn::ldn::AddressEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (entries))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(securityConfig, (::nn::ldn::SecurityConfig), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(securityParam, (::nn::ldn::SecurityParameter), 68)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::ldn::UserConfig), 100)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(network, (::nn::ldn::NetworkConfig), 152)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (securityConfig, securityParam, user, network))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(184)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(network), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(securityConfig), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(securityParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateNetworkPrivate)

    // nn::Result DestroyNetwork() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyNetwork)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyNetwork)

    // nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Reject)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::ldn::Ipv4Address), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Reject)

    // nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAdvertiseData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAdvertiseData)

    // nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetStationAcceptPolicy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(policy, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (policy))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(policy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetStationAcceptPolicy)

    // nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddAcceptFilterEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(station, (::nn::ldn::MacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (station))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(station)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddAcceptFilterEntry)

    // nn::Result ClearAcceptFilter() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearAcceptFilter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearAcceptFilter)

    // nn::Result OpenStation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenStation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenStation)

    // nn::Result CloseStation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseStation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseStation)

    // nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(network, 0, (const ::nn::ldn::NetworkInfo&), 1152, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (network))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(security, (::nn::ldn::SecurityConfig), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::ldn::UserConfig), 68)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::int32_t), 116)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::Bit32), 120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (security, user, version, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(124)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(network), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(security), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConnectPrivate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(securityConfig, (::nn::ldn::SecurityConfig), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(securityParam, (::nn::ldn::SecurityParameter), 68)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::ldn::UserConfig), 100)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::int32_t), 148)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::Bit32), 152)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(network, (::nn::ldn::NetworkConfig), 160)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (securityConfig, securityParam, user, version, option, network))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(192)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(network), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(securityConfig), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(securityParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConnectPrivate)

    // nn::Result Disconnect() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Disconnect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Disconnect)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkInfo), 1152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::Ipv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SubnetMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityParameter), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkConfig), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NodeLatestUpdate), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::ScanFilter), 96, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityConfig), 68, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::UserConfig), 48, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::AddressEntry), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::MacAddress), 6, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::ILocalCommunicationService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::ldn::detail::ILocalCommunicationService), (::nn::ldn::detail::IStateGetService))

    // nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateChangeEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutReadableHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReadableHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateChangeEvent)
    }

    // nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInfoAndHistory, (::nn::sf::Out<::nn::ldn::NetworkInfo> pOutNetwork, const ::nn::sf::OutArray<::nn::ldn::NodeLatestUpdate>& outUpdates))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkInfoAndHistory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNetwork)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUpdates)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkInfoAndHistory)
    }

    // nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Scan, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Scan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutScanResultArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Scan)
    }

    // nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ScanPrivate, (const ::nn::sf::OutArray<::nn::ldn::NetworkInfo>& pOutScanResultArray, ::nn::sf::Out<::std::int16_t> pOutCount, const ::nn::ldn::ScanFilter& filter, ::std::int16_t channel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ScanPrivate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutScanResultArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ScanPrivate)
    }

    // nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWirelessControllerRestriction, (::nn::Bit32 restriction))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWirelessControllerRestriction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(restriction)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWirelessControllerRestriction)
    }

    // nn::Result OpenAccessPoint() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenAccessPoint)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAccessPoint)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAccessPoint)
    }

    // nn::Result CloseAccessPoint() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseAccessPoint)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseAccessPoint)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseAccessPoint)
    }

    // nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetwork, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateNetwork)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(network)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(security)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateNetwork)
    }

    // nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, const ::nn::sf::InArray<::nn::ldn::AddressEntry>& entries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateNetworkPrivate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(network)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(securityConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(securityParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateNetworkPrivate)
    }

    // nn::Result DestroyNetwork() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyNetwork)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyNetwork)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyNetwork)
    }

    // nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Reject, (::nn::ldn::Ipv4Address address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Reject)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Reject)
    }

    // nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAdvertiseData, (const ::nn::sf::InBuffer& data))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAdvertiseData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAdvertiseData)
    }

    // nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetStationAcceptPolicy, (::nn::Bit8 policy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetStationAcceptPolicy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(policy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetStationAcceptPolicy)
    }

    // nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddAcceptFilterEntry, (::nn::ldn::MacAddress station))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddAcceptFilterEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(station)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddAcceptFilterEntry)
    }

    // nn::Result ClearAcceptFilter() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearAcceptFilter)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearAcceptFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearAcceptFilter)
    }

    // nn::Result OpenStation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenStation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenStation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenStation)
    }

    // nn::Result CloseStation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseStation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseStation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseStation)
    }

    // nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::ldn::NetworkInfo& network, const ::nn::ldn::SecurityConfig& security, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(network)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(security)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectPrivate, (const ::nn::ldn::NetworkConfig& network, const ::nn::ldn::SecurityConfig& securityConfig, const ::nn::ldn::SecurityParameter& securityParam, const ::nn::ldn::UserConfig& user, ::std::int32_t version, ::nn::Bit32 option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConnectPrivate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(network)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(securityConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(securityParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConnectPrivate)
    }

    // nn::Result Disconnect() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Disconnect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Disconnect)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::ILocalCommunicationService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::ldn::detail::ILocalCommunicationService), (::nn::ldn::detail::IStateGetService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkInfoAndHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutNetwork)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUpdates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkInfoAndHistory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutNetwork),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUpdates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Scan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutScanResultArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Scan)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutScanResultArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ScanPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutScanResultArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ScanPrivate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutScanResultArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWirelessControllerRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWirelessControllerRestriction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(restriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateNetwork)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(network),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(security),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateNetworkPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(entries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateNetworkPrivate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(network),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(securityConfig),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(securityParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(entries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Reject)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Reject)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAdvertiseData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAdvertiseData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetStationAcceptPolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetStationAcceptPolicy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(policy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddAcceptFilterEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddAcceptFilterEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(station)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearAcceptFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearAcceptFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(network)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(network),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(security),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConnectPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConnectPrivate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(network),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(securityConfig),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(securityParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkInfoAndHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Scan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ScanPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWirelessControllerRestriction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseAccessPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateNetworkPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyNetwork)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Reject)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAdvertiseData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetStationAcceptPolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddAcceptFilterEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearAcceptFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseStation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConnectPrivate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Disconnect)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::ILocalCommunicationService))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMonitorService, (::nn::ldn::detail::IStateGetService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMonitorService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMonitorService)

        ::nn::Result Initialize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Initialize);
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMonitorService : public ::nn::ldn::detail::IStateGetService
    {
    public:
        nn::Result Initialize() NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
    nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
    nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
    nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
    nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
    nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::ldn::detail::IMonitorService), (::nn::ldn::detail::IStateGetService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Initialize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::IMonitorService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::ldn::detail::IMonitorService), (::nn::ldn::detail::IStateGetService))

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkInfo), 1152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::Ipv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SubnetMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityParameter), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkConfig), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::IMonitorService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::ldn::detail::IMonitorService), (::nn::ldn::detail::IStateGetService))

    // nn::Result Initialize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Initialize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::IMonitorService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::ldn::detail::IMonitorService), (::nn::ldn::detail::IStateGetService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::IMonitorService))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMonitorServiceCreator, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMonitorServiceCreator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateMonitorService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IMonitorService>> pOutService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMonitorServiceCreator)

        ::nn::Result CreateMonitorService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IMonitorService>> pOutService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateMonitorService, (pOutService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMonitorServiceCreator
    {
    public:
        nn::Result CreateMonitorService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IMonitorService>> pOutService) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateMonitorService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IMonitorService>> pOutService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ldn::detail::IMonitorServiceCreator))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMonitorService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IMonitorService>> pOutService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateMonitorService, (pOutService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::IMonitorServiceCreator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ldn::detail::IMonitorServiceCreator))

    // nn::Result CreateMonitorService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IMonitorService>> pOutService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateMonitorService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateMonitorService)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::IMonitorServiceCreator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ldn::detail::IMonitorServiceCreator))

    // nn::Result CreateMonitorService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IMonitorService>> pOutService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateMonitorService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IMonitorService>> pOutService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateMonitorService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateMonitorService)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::IMonitorServiceCreator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ldn::detail::IMonitorServiceCreator))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateMonitorService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ldn::detail::IMonitorService>), pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateMonitorService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateMonitorService)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::IMonitorServiceCreator))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemLocalCommunicationService, (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemLocalCommunicationService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOperationMode, (::nn::Bit32 mode))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemLocalCommunicationService)

        ::nn::Result Initialize(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (pid));
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

        ::nn::Result SetOperationMode(::nn::Bit32 mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOperationMode, (mode));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemLocalCommunicationService : public ::nn::ldn::detail::ILocalCommunicationService
    {
    public:
        nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
        nn::Result SetOperationMode(nn::Bit32 mode) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
    nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
    nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
    nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
    nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
    nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT;
    nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT;
    nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT;
    nn::Result OpenAccessPoint() NN_NOEXCEPT;
    nn::Result CloseAccessPoint() NN_NOEXCEPT;
    nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT;
    nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT;
    nn::Result DestroyNetwork() NN_NOEXCEPT;
    nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT;
    nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT;
    nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT;
    nn::Result ClearAcceptFilter() NN_NOEXCEPT;
    nn::Result OpenStation() NN_NOEXCEPT;
    nn::Result CloseStation() NN_NOEXCEPT;
    nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result Disconnect() NN_NOEXCEPT;
    nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result SetOperationMode(nn::Bit32 mode) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::ldn::detail::ISystemLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOperationMode, (::nn::Bit32 mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOperationMode, (mode));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::ISystemLocalCommunicationService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::ldn::detail::ISystemLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    // nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    // nn::Result SetOperationMode(nn::Bit32 mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOperationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOperationMode)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkInfo), 1152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::Ipv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SubnetMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityParameter), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkConfig), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NodeLatestUpdate), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::ScanFilter), 96, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityConfig), 68, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::UserConfig), 48, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::AddressEntry), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::MacAddress), 6, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::ISystemLocalCommunicationService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::ldn::detail::ISystemLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    // nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

    // nn::Result SetOperationMode(nn::Bit32 mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOperationMode, (::nn::Bit32 mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOperationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOperationMode)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::ISystemLocalCommunicationService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::ldn::detail::ISystemLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOperationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOperationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOperationMode)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::ISystemLocalCommunicationService))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemServiceCreator, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemServiceCreator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::ISystemLocalCommunicationService>> pOutService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemServiceCreator)

        ::nn::Result CreateSystemLocalCommunicationService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::ISystemLocalCommunicationService>> pOutService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSystemLocalCommunicationService, (pOutService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemServiceCreator
    {
    public:
        nn::Result CreateSystemLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::ISystemLocalCommunicationService>> pOutService) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateSystemLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::ISystemLocalCommunicationService>> pOutService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ldn::detail::ISystemServiceCreator))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::ISystemLocalCommunicationService>> pOutService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSystemLocalCommunicationService, (pOutService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::ISystemServiceCreator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ldn::detail::ISystemServiceCreator))

    // nn::Result CreateSystemLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::ISystemLocalCommunicationService>> pOutService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSystemLocalCommunicationService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSystemLocalCommunicationService)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::ISystemServiceCreator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ldn::detail::ISystemServiceCreator))

    // nn::Result CreateSystemLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::ISystemLocalCommunicationService>> pOutService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::ISystemLocalCommunicationService>> pOutService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSystemLocalCommunicationService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSystemLocalCommunicationService)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::ISystemServiceCreator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ldn::detail::ISystemServiceCreator))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSystemLocalCommunicationService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ldn::detail::ISystemLocalCommunicationService>), pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSystemLocalCommunicationService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSystemLocalCommunicationService)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::ISystemServiceCreator))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUserLocalCommunicationService, (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUserLocalCommunicationService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUserLocalCommunicationService)

        ::nn::Result Initialize(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (pid));
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUserLocalCommunicationService : public ::nn::ldn::detail::ILocalCommunicationService
    {
    public:
        nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetState(nn::sf::Out<nn::Bit32> pOutState) NN_NOEXCEPT;
    nn::Result GetNetworkInfo(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork) NN_NOEXCEPT;
    nn::Result GetIpv4Address(nn::sf::Out<nn::ldn::Ipv4Address> pOutAddress, nn::sf::Out<nn::ldn::SubnetMask> pOutMask) NN_NOEXCEPT;
    nn::Result GetDisconnectReason(nn::sf::Out<std::int16_t> pOutReason) NN_NOEXCEPT;
    nn::Result GetSecurityParameter(nn::sf::Out<nn::ldn::SecurityParameter> pOutSecurityParameter) NN_NOEXCEPT;
    nn::Result GetNetworkConfig(nn::sf::Out<nn::ldn::NetworkConfig> pOutNetworkConfig) NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) NN_NOEXCEPT;
    nn::Result GetNetworkInfoAndHistory(nn::sf::Out<nn::ldn::NetworkInfo> pOutNetwork, const nn::sf::OutArray<nn::ldn::NodeLatestUpdate>& outUpdates) NN_NOEXCEPT;
    nn::Result Scan(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result ScanPrivate(const nn::sf::OutArray<nn::ldn::NetworkInfo>& pOutScanResultArray, nn::sf::Out<std::int16_t> pOutCount, const nn::ldn::ScanFilter& filter, std::int16_t channel) NN_NOEXCEPT;
    nn::Result SetWirelessControllerRestriction(nn::Bit32 restriction) NN_NOEXCEPT;
    nn::Result OpenAccessPoint() NN_NOEXCEPT;
    nn::Result CloseAccessPoint() NN_NOEXCEPT;
    nn::Result CreateNetwork(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user) NN_NOEXCEPT;
    nn::Result CreateNetworkPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, const nn::sf::InArray<nn::ldn::AddressEntry>& entries) NN_NOEXCEPT;
    nn::Result DestroyNetwork() NN_NOEXCEPT;
    nn::Result Reject(nn::ldn::Ipv4Address address) NN_NOEXCEPT;
    nn::Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT;
    nn::Result SetStationAcceptPolicy(nn::Bit8 policy) NN_NOEXCEPT;
    nn::Result AddAcceptFilterEntry(nn::ldn::MacAddress station) NN_NOEXCEPT;
    nn::Result ClearAcceptFilter() NN_NOEXCEPT;
    nn::Result OpenStation() NN_NOEXCEPT;
    nn::Result CloseStation() NN_NOEXCEPT;
    nn::Result Connect(const nn::ldn::NetworkInfo& network, const nn::ldn::SecurityConfig& security, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ConnectPrivate(const nn::ldn::NetworkConfig& network, const nn::ldn::SecurityConfig& securityConfig, const nn::ldn::SecurityParameter& securityParam, const nn::ldn::UserConfig& user, std::int32_t version, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result Disconnect() NN_NOEXCEPT;
    nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::ldn::detail::IUserLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::IUserLocalCommunicationService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::ldn::detail::IUserLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    // nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkInfo), 1152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::Ipv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SubnetMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityParameter), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NetworkConfig), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::NodeLatestUpdate), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::ScanFilter), 96, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::SecurityConfig), 68, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::UserConfig), 48, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::AddressEntry), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ldn::MacAddress), 6, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::IUserLocalCommunicationService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::ldn::detail::IUserLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    // nn::Result Initialize(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::IUserLocalCommunicationService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::ldn::detail::IUserLocalCommunicationService), (::nn::ldn::detail::ILocalCommunicationService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::IUserLocalCommunicationService))

namespace nn { namespace ldn { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUserServiceCreator, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUserServiceCreator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IUserLocalCommunicationService>> pOutService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUserServiceCreator)

        ::nn::Result CreateUserLocalCommunicationService(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IUserLocalCommunicationService>> pOutService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateUserLocalCommunicationService, (pOutService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUserServiceCreator
    {
    public:
        nn::Result CreateUserLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IUserLocalCommunicationService>> pOutService) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateUserLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IUserLocalCommunicationService>> pOutService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ldn::detail::IUserServiceCreator))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IUserLocalCommunicationService>> pOutService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateUserLocalCommunicationService, (pOutService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ldn::detail::IUserServiceCreator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ldn::detail::IUserServiceCreator))

    // nn::Result CreateUserLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IUserLocalCommunicationService>> pOutService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateUserLocalCommunicationService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateUserLocalCommunicationService)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ldn::detail::IUserServiceCreator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ldn::detail::IUserServiceCreator))

    // nn::Result CreateUserLocalCommunicationService(nn::sf::Out<nn::sf::SharedPointer<nn::ldn::detail::IUserLocalCommunicationService>> pOutService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserLocalCommunicationService, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ldn::detail::IUserLocalCommunicationService>> pOutService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateUserLocalCommunicationService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateUserLocalCommunicationService)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ldn::detail::IUserServiceCreator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ldn::detail::IUserServiceCreator))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateUserLocalCommunicationService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ldn::detail::IUserLocalCommunicationService>), pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateUserLocalCommunicationService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateUserLocalCommunicationService)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ldn::detail::IUserServiceCreator))
