﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_MacAddress.h>
#include <nn/ldn/detail/NetworkInterface/ldn_Ethernet.h>
#include <nn/ldn/detail/NetworkInterface/ldn_ProtocolId.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         任天堂の OUI です。
     */
    const Oui NintendoOui = MakeOui(0x00, 0x22, 0xAA);

    /**
     * @brief         任天堂定義の OUI Extended Ethertype のヘッダです。
     */
    struct NintendoEthernetHeader
    {
        ProtocolId                  protocol;
        char                        _reserved;
    };

    /**
     * @brief         任天堂定義の OUI Extended Ethertype フレームの最大ペイロードサイズです。
     */
    const size_t NintendoEthernetFramePayloadSizeMax = 492;
    // const size_t NintendoEthernetFramePayloadSizeMax =
    //     OuiExtendedEthernetFramePayloadSizeMax - sizeof(NintendoEthernetHeader);

    /**
     * @brief         任天堂定義の OUI Extended Ethertype のフレームです。
     */
    struct NintendoEthernetFrame
    {
        EthernetHeader              ethernetHeader;
        OuiExtendedEthernetHeader   ouiExtendedEthernetHeader;
        NintendoEthernetHeader      nintendoEthernetHeader;
        Bit8                        data[NintendoEthernetFramePayloadSizeMax];
    };
    NN_STATIC_ASSERT(sizeof(NintendoEthernetFrame) <= sizeof(EthernetFrame));

    /**
     * @brief         任天堂定義の OUI Extended Ethertype フレームの最小サイズです。
     */
    const size_t NintendoEthernetFrameSizeMin =
        sizeof(NintendoEthernetFrame) - NintendoEthernetFramePayloadSizeMax;

    /**
     * @brief         任天堂定義の情報エレメントのペイロードの最大サイズです。
     */
    const size_t NintendoIePayloadSizeMax
        = VendorSpecificIePayloadSizeMax - sizeof(ProtocolId) - 1;

    /**
     * @brief         任天堂定義の Vendor Specific Information Element のヘッダです。
     */
    struct NintendoIeHeader
    {
        Bit8                        elementId;
        uint8_t                     length;
        Oui                         oui;
        ProtocolId                  protocolId;
        Bit8                        _reserved;
    };

    /**
     * @brief         任天堂定義の情報エレメントです。
     */
    struct NintendoIe
    {
        NintendoIeHeader            header;
        Bit8                        payload[NintendoIePayloadSizeMax];
    };
    NN_STATIC_ASSERT(sizeof(Ie) == sizeof(NintendoIe));

    /**
     * @brief         Action Frame のサブタイプです。
     */
    enum ActionFrameSubType
    {
        ActionFrameSubType_Advertise        = 4
    };

    /**
     * @brief         任天堂定義の Action Frame のヘッダです。
     */
    struct NintendoActionFrameHeader
    {
        Bit8                        category;
        Oui                         oui;
        Bit8                        subType;
        char                        _reserved;
        ProtocolId                  protocol;
    };

    /**
     * @brief         任天堂定義の Action Frame のペイロードの最大サイズです。
     */
    const size_t NintendoActionFramePayloadSizeMax =
        ActionFramePayloadSizeMax - sizeof(NintendoActionFrameHeader);

    /**
     * @brief         任天堂定義の Action Frame です。
     */
    struct NintendoActionFrame
    {
        ActionFrameHeader actionFrameHeader;
        NintendoActionFrameHeader nintendoActionFrameHeader;
        Bit8 payload[NintendoActionFramePayloadSizeMax];
    };
    NN_STATIC_ASSERT(sizeof(ActionFrame) == sizeof(NintendoActionFrame));

}}} // namespace nn::ldn::server::detail
