﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_MacAddress.h>
#include <nn/ldn/ldn_Ssid.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief           ネットワークの情報を格納する構造体です。
     */
    struct NetworkProfile
    {
        //! ネットワークの BSSID です。
        MacAddress      bssid;

        //! ネットワークの SSID です。
        Ssid            ssid;

        //! ネットワークの無線チャンネルです。
        int16_t         channel;
        Bit8            _reserved[6];
    };

}}} // namespace nn::ldn::detail
