﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterfaceBase.h>
#include <nn/os.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief         L2 上の端末のインタフェースです。
     */
    class NetworkInterfaceStub : public NetworkInterfaceBase
    {
    public:

        static size_t GetRequiredBufferSize() NN_NOEXCEPT;

        NetworkInterfaceStub(void* buffer, size_t bufferSize) NN_NOEXCEPT;

        virtual ~NetworkInterfaceStub() NN_NOEXCEPT;

        virtual nn::os::SystemEvent& GetStateChangeEvent() NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::os::SystemEvent& GetBeaconReceivedEvent() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result GetNetworkProfile(
            NetworkProfile* pOutProfile) const NN_NOEXCEPT NN_OVERRIDE;

        virtual void GetNetworkInterfaceProfile(
            NetworkInterfaceProfile* pOutProfile) const NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Scan(
            L2ScanResult* outBuffer, int* pOutCount, int bufferCount,
            int channel) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result OpenAccessPoint() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result SetBeaconData(const void* data, size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result CreateNetwork(
            const Ssid& ssid, int channel, int nodeCountMax,
            const void* key, size_t keySize) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Reject(MacAddress address) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result GetStations(
            L2StationInfo* outStations,
            int* pOutCount, int bufferCount) const NN_NOEXCEPT NN_OVERRIDE;

        virtual Result DestroyNetwork() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result CloseAccessPoint() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result OpenStation() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Connect(
            const Ssid& ssid, int channel, int nodeCountMax,
            const void* key, size_t keySize) NN_NOEXCEPT NN_OVERRIDE;

        virtual bool GetBeaconData(L2ScanResult* pOutBeacon) const NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Disconnect() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result GetConnectionStatus(L2StationInfo* pOut) const NN_NOEXCEPT NN_OVERRIDE;

        virtual Result CloseStation() NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Send(const void* data, size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Receive(
            void* buffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT NN_OVERRIDE;

        virtual Result Cancel() NN_NOEXCEPT NN_OVERRIDE;

        virtual L2State GetState() const NN_NOEXCEPT NN_OVERRIDE;

        virtual void SetOperationMode(OperationMode mode) NN_NOEXCEPT NN_OVERRIDE;

        virtual void SetWirelessControllerRestriction(
            WirelessControllerRestriction restriction) NN_NOEXCEPT NN_OVERRIDE;

    private:

        virtual int ConvertRssiToLinkLevel(int rssi) const NN_NOEXCEPT NN_OVERRIDE;

        nn::os::SystemEvent m_StateChangeEvent;
        nn::os::SystemEvent m_BeaconReceivedEvent;
        nn::os::SystemEvent m_CancelEvent;
        Ssid m_Ssid;
        int m_Channel;
        L2State m_Status;
    };

}}} // namespace nn::ldn::detail
