﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/ldn_NetworkId.h>
#include <nn/ldn/detail/ldn_Version.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseBuilder.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseFormat.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseParser.h>
#include <nn/ldn/detail/Utility/ldn_Digest.h>

namespace nn { namespace ldn { namespace detail { namespace impl
{
    /**
     * @brief         平文の Advertise を構築するクラスです。
     */
    class PlainAdvertiseBuilderImpl
    {
    public:

        PlainAdvertiseBuilderImpl(
            AdvertiseFormat format, CalculateDigest digest) NN_NOEXCEPT;

        ~PlainAdvertiseBuilderImpl() NN_NOEXCEPT;

        static size_t GetRequiredBufferSize() NN_NOEXCEPT;

        void SetNetworkId(const NetworkId& networkId) NN_NOEXCEPT;

        void SetVersion(Version version) NN_NOEXCEPT;

        void Build(
            void* pOutAdvertise, size_t* pOutSize, size_t bufferSize,
            const void* data, size_t dataSize) NN_NOEXCEPT;

    private:

        CalculateDigest m_CalculateDigest;
        NetworkId       m_NetworkId;
        uint32_t        m_Counter;
        Version         m_Version;
        bool            m_HasNetworkId;
        bool            m_HasVersion;
        Bit8            m_Format;
    };

    /**
     * @brief         平文の Advertise を解析するクラスです。
     */
    class PlainAdvertiseParserImpl
    {
    public:

        static size_t GetRequiredBufferSize() NN_NOEXCEPT;

        PlainAdvertiseParserImpl(
            void* buffer, size_t bufferSize,
            AdvertiseFormat format, CalculateDigest digest) NN_NOEXCEPT;

        ~PlainAdvertiseParserImpl() NN_NOEXCEPT;

        AdvertiseParserResult VerifyHeader(const void* data, size_t dataSize) const NN_NOEXCEPT;

        AdvertiseParserResult VerifySign(const void* data, size_t dataSize) NN_NOEXCEPT;

        void Parse(const void* data, size_t dataSize) NN_NOEXCEPT;

        const NetworkId GetNetworkId() const NN_NOEXCEPT;

        const Version GetVersion() const NN_NOEXCEPT;

        size_t GetDataSize() const NN_NOEXCEPT;

        const void* GetData() const NN_NOEXCEPT;

    private:

        CalculateDigest m_CalculateDigest;
        Advertise* m_pAdvertise;
        Advertise* m_pPreviousAdvertise;
        AdvertiseFormat m_Format;
        bool m_HasParsedData;
    };

}}}} // end of namespace nn::ldn::detail::impl
