﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseBuilder.h>
#include <nn/ldn/detail/Advertise/ldn_AdvertiseParser.h>
#include <nn/ldn/detail/Advertise/ldn_PlainAdvertiseImpl.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief       AES-128 CTR で暗号化された Advertise を構築するクラスです。
     */
    class Aes128CtrSha256AdvertiseBuilder : public IAdvertiseBuilder
    {
    public:

        static size_t GetRequiredBufferSize() NN_NOEXCEPT;

        Aes128CtrSha256AdvertiseBuilder(
            void* buffer, size_t bufferSize, const Bit8 (&key)[16]) NN_NOEXCEPT;

        virtual ~Aes128CtrSha256AdvertiseBuilder() NN_NOEXCEPT;

        virtual void SetNetworkId(const NetworkId& networkId) NN_NOEXCEPT NN_OVERRIDE;

        virtual void SetVersion(Version version) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Build(
            void* pOutAdvertise, size_t* pOutSize, size_t bufferSize,
            const void* data, size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;

    private:

        impl::PlainAdvertiseBuilderImpl m_Impl;
        Advertise&                      m_Buffer;
        Bit8                            m_AesKey[16];
    };

    /**
     * @brief       AES-128 CTR で暗号化された Advertise を解析するクラスです。
     */
    class AesCtr128Sha256AdvertiseParser : public IAdvertiseParser
    {
    public:

        static size_t GetRequiredBufferSize() NN_NOEXCEPT;

        AesCtr128Sha256AdvertiseParser(
            void* buffer, size_t bufferSize, const Bit8 (&key)[16]) NN_NOEXCEPT;

        virtual ~AesCtr128Sha256AdvertiseParser() NN_NOEXCEPT;

        virtual AdvertiseParserResult Parse(
            const void* data, size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;

        virtual const NetworkId GetNetworkId() const NN_NOEXCEPT NN_OVERRIDE;

        virtual const Version GetVersion() const NN_NOEXCEPT NN_OVERRIDE;

        virtual size_t GetDataSize() const NN_NOEXCEPT NN_OVERRIDE;

        virtual const void* GetData() const NN_NOEXCEPT NN_OVERRIDE;

    private:

        impl::PlainAdvertiseParserImpl  m_Impl;
        Advertise&                      m_DecryptedAdvertise;
        Bit8                            m_AesKey[16];
    };

}}} // namespace nn::ldn::detail
