﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

 /**
 * @file
 * @brief       ローカルコンテンツ配信ライブラリの非公開デバッグ API の宣言
 */

#include <nn/nn_Common.h>
#include <nn/lcs/detail/lcs_Definition.h>

namespace nn { namespace lcs
{
    enum InnerRole
    {
        InnerRole_None,
        InnerRole_Master,
        InnerRole_Slave,
    };

    void SetLocalCommunicationId(Bit64 id) NN_NOEXCEPT;

    Bit64 GetLocalCommunicationId() NN_NOEXCEPT;

    void SetInnerRole(InnerRole role) NN_NOEXCEPT;

    InnerRole GetInnerRole() NN_NOEXCEPT;

    void SetSceneId(Bit16 id) NN_NOEXCEPT;

    Bit16 GetSceneId() NN_NOEXCEPT;


}} // namespace nn::lcs
