﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief       ローカルコンテンツ配信ライブラリの初期化設定の定義
 */

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>

namespace nn { namespace lcs
{
    /**
     * @brief        LCS ライブラリの初期化に使用する設定クラスです。
     *
     * @details
     * LCS ライブラリの初期化に使用する設定クラスです。
     * Initialize() の引数として使用します。
     */
    class Config
    {
    public:

        /**
         * @brief       コンストラクタです。
         */
        Config() NN_NOEXCEPT;

        /**
         * @brief       ユーザー名を設定します。
         * @param[in]   name            ユーザー名です。
         *
         * @details
         * ユーザー名を設定します。
         * UTF-8 で最大サイズは @ref UserNameBytesMax です。
         */
        void SetName(const char* name) NN_NOEXCEPT;

        /**
         * @brief       ユーザー名を取得します。
         * @param[in]   pOutName        ユーザ名の出力先です。
         * @param[in]   pOutSize        ユーザ名の出力サイズです。終端文字を含みます。
         * @param[in]   size            出力先のサイズです。
         *
         * @details
         * ユーザー名を取得します。
         * UTF-8 で最大サイズは @ref UserNameBytesMax + 1 で終端文字を含みます。
         */
        void GetName(char* pOutName, size_t* pOutSize, size_t size) const NN_NOEXCEPT;

    private:
        char m_Name[UserNameBytesMax + 1];
    };

}} // namespace nn::lcs
