﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace lcs { namespace detail
{

    class EventManager
    {
    public:
        EventManager() NN_NOEXCEPT;

        void Initialize(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        void SignalEvent() NN_NOEXCEPT;

    private:
        nn::os::SystemEventType* m_StateChangeEvent;
        bool m_IsAttachEvent;

    };

}}} // end of namespace nn::lcs
