﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lcs/detail/lcs_Version.h>
#include <nn/ldn/ldn_Types.h>

namespace nn { namespace lcs { namespace detail
{

    const Bit64 DefaultLocalCommunicationId = 0x0100000000001000;

    const Bit16 DefaultSceneId = UINT16_C(0x0001);

    const Bit16 ShareSceneId = UINT16_C(0x0002);

    const Bit8 Passphrase[] = { 0x2D, 0x30, 0x88, 0x5A, 0x65, 0x8A, 0xB4, 0xE4,
        0xD8, 0x50, 0x92, 0xED, 0x52, 0x5A, 0x99, 0x4C };

    const char HostUserName[] = "LcsHost";

    const char ClientUserName[] = "LcsClient";

    const int TcpPort = 55555;

    const int SharePort = 55556;

    //! プロトコルの必須メジャーバージョンです。
    const int RequiredMajorVersion = 1;

    //! プロトコルの必須マイナーバージョンです。
    const int RequiredMinorVersion = 0;

}}} // end of namespace nn::lcs
